/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class TokenReader
extends Reader {
    protected String token;
    protected boolean isPushedBack = false;
    protected Reader delegate;

    public TokenReader(Reader reader) {
        this.delegate = reader;
    }

    public int read() throws IOException {
        int result;
        if (this.isPushedBack) {
            char c = this.token.charAt(0);
            this.token = this.token.substring(1);
            if (this.token.length() == 0) {
                this.isPushedBack = false;
            }
            result = Character.getNumericValue(c);
        } else {
            result = super.read();
        }
        return result;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int actualBytesRead;
        int result = 0;
        if (this.isPushedBack) {
            int length;
            if (this.token.length() <= len) {
                this.isPushedBack = false;
                length = this.token.length();
            } else {
                length = len;
            }
            this.token.getChars(0, length, cbuf, off);
            len -= length;
            off += length;
            if (this.isPushedBack) {
                this.token = this.token.substring(length);
            }
            result = length;
        }
        result = (actualBytesRead = this.delegate.read(cbuf, off, len)) != -1 ? (result += actualBytesRead) : -1;
        return result;
    }

    public String readLine() throws IOException {
        int c;
        StringBuffer result = new StringBuffer();
        if (this.isPushedBack) {
            result.append(this.token);
            this.isPushedBack = false;
        }
        while ((c = this.read()) != 10 && c != -1) {
            result.append((char)c);
        }
        return result.toString();
    }

    public long skip(long n) throws IOException {
        long skipped = 0L;
        if (this.isPushedBack) {
            int tokenLength = this.token.length();
            skipped = n < (long)tokenLength ? n : (long)tokenLength;
            n -= skipped;
            this.token = this.token.substring((int)skipped);
            if (this.token.length() == 0) {
                this.isPushedBack = false;
            }
        }
        return skipped += super.skip(n);
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public String readToken() throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        String whitespace = " \t\n\r";
        do {
            if ((c = this.read()) != -1) continue;
            throw new EOFException();
        } while (" \t\n\r".indexOf(c) != -1);
        buf.append((char)c);
        boolean done = false;
        while (!done) {
            c = this.read();
            if (c == -1) {
                throw new EOFException();
            }
            if (" \t\n\r".indexOf(c) != -1) {
                done = true;
                continue;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public int readInt() throws IOException, NumberFormatException {
        return Integer.parseInt(this.readToken());
    }

    public long readLong() throws IOException, NumberFormatException {
        return Long.parseLong(this.readToken());
    }

    public boolean readBoolean() throws IOException {
        return Boolean.valueOf(this.readToken());
    }

    public void unreadString(String s) {
        this.token = s;
        this.isPushedBack = true;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public static void main(String[] args) {
        TokenReader reader = new TokenReader(new InputStreamReader(System.in));
        boolean done = false;
        do {
            try {
                String token = reader.readToken();
                System.out.println("'" + token + "'");
                token = reader.readLine();
                System.out.println("'" + token + "'");
            }
            catch (EOFException e) {
                done = true;
            }
            catch (IOException e) {
                System.err.println(e);
                done = true;
            }
        } while (!done);
    }
}

