/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import edu.berkeley.guir.lib.gesture.util.awt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectablePanel
extends JPanel
implements ListSelectionListener {
    public static String SELECTABLE_PROP = "selectable";
    protected ListSelectionModel selectionModel = null;
    protected PropertyChangeSupport propChangeSupport;
    public static final int DEFAULT_BORDER_WIDTH = 3;
    public static final Border DEFAULT_SELECTED_BORDER = BorderFactory.createMatteBorder(3, 3, 3, 3, Color.black);
    public static final Border DEFAULT_UNSELECTED_BORDER = null;
    protected Border selectedBorder = DEFAULT_SELECTED_BORDER;
    protected Border unselectedBorder = DEFAULT_UNSELECTED_BORDER;
    protected MouseListener selectMouseListener = this.getMouseListener();
    protected boolean isSelectable = false;

    public SelectablePanel() {
        this.propChangeSupport = new PropertyChangeSupport(this);
        this.setSelectable(true);
        this.setSelectionModel(new DefaultListSelectionModel());
        this.selectionModel.setSelectionMode(2);
    }

    public void setSelectable(boolean on) {
        if (on != this.isSelectable) {
            this.isSelectable = on;
            if (on) {
                this.addMouseListener(this.selectMouseListener);
            } else {
                this.removeMouseListener(this.selectMouseListener);
            }
            this.propChangeSupport.firePropertyChange(SELECTABLE_PROP, !on, on);
        }
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (model != this.selectionModel) {
            if (this.selectionModel != null) {
                this.selectionModel.removeListSelectionListener(this);
            }
            this.selectionModel = model;
            if (this.selectionModel != null) {
                this.selectionModel.addListSelectionListener(this);
            }
        }
    }

    public List getSelectedObjects() {
        int numComponents = this.getComponentCount();
        ArrayList<Component> list = new ArrayList<Component>();
        int i = 0;
        while (i < numComponents) {
            if (this.selectionModel.isSelectedIndex(i)) {
                list.add(this.getContainee(i));
            }
            ++i;
        }
        return list;
    }

    public void setSelectedBorder(Border b) {
        this.selectedBorder = b;
    }

    public Border getSelectedBorder() {
        return this.selectedBorder;
    }

    public void setUnselectedBorder(Border b) {
        this.unselectedBorder = b;
    }

    public Border getUnselectedBorder() {
        return this.unselectedBorder;
    }

    public void selectToChild(Component child) {
        int childIndex = awt.getChildIndex(this, child);
        this.selectionModel.setLeadSelectionIndex(childIndex);
    }

    public void toggleSelection(Component child) {
        int childIndex = awt.getChildIndex(this, child);
        if (this.selectionModel.isSelectedIndex(childIndex)) {
            this.selectionModel.removeSelectionInterval(childIndex, childIndex);
        } else {
            this.selectionModel.addSelectionInterval(childIndex, childIndex);
        }
    }

    public void setSelection(Component child) {
        int childIndex = awt.getChildIndex(this, child);
        this.selectionModel.setSelectionInterval(childIndex, childIndex);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        SingletonContainer container = new SingletonContainer(comp);
        super.addImpl(container, constraints, index);
        if (index == -1) {
            index = this.getComponentCount() - 1;
        }
        this.selectionModel.insertIndexInterval(index, 1, true);
    }

    public Component getContainee(int index) {
        return ((SingletonContainer)this.getComponent(index)).getContainee();
    }

    protected int getContaineeIndex(Component containee) {
        int i = 0;
        while (i < this.getComponentCount()) {
            SingletonContainer sc = (SingletonContainer)this.getComponent(i);
            if (containee == sc.getContainee()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void remove(Component comp) {
        int index = awt.getChildIndex(this, comp);
        if (index == -1) {
            index = this.getContaineeIndex(comp);
        }
        this.remove(index);
    }

    public void remove(int index) {
        this.selectionModel.removeIndexInterval(index, index);
        super.remove(index);
    }

    public void removeAll() {
        int componentCount = this.getComponentCount();
        if (componentCount > 0) {
            this.selectionModel.removeIndexInterval(0, componentCount - 1);
        }
        super.removeAll();
    }

    public void valueChanged(ListSelectionEvent e) {
        int maxIndex = Math.min(e.getLastIndex(), this.getComponentCount() - 1);
        int i = e.getFirstIndex();
        while (i <= maxIndex) {
            Component comp = this.getComponent(i);
            if (comp instanceof JComponent) {
                ((JComponent)comp).setBorder(this.selectionModel.isSelectedIndex(i) ? this.selectedBorder : this.unselectedBorder);
                ((JComponent)comp).setPreferredSize(null);
            }
            ++i;
        }
        this.revalidate();
    }

    protected MouseListener getMouseListener() {
        return new SelectMouseListener();
    }

    protected class SelectMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                Point location = e.getPoint();
                Component child = SelectablePanel.this.getComponentAt(location);
                int modifiers = e.getModifiers() & 0xB;
                switch (modifiers) {
                    case 1: {
                        SelectablePanel.this.selectToChild(child);
                        break;
                    }
                    case 2: {
                        SelectablePanel.this.toggleSelection(child);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    default: {
                        SelectablePanel.this.setSelection(child);
                    }
                }
            }
        }
    }

    public class SingletonContainer
    extends JPanel {
        private Component containee;

        public SingletonContainer(Component containee) {
            super(new BorderLayout());
            this.setContainee(containee);
        }

        public void setContainee(Component containee) {
            this.removeAll();
            this.add(containee, "Center");
            this.containee = containee;
        }

        public Component getContainee() {
            return this.getComponent(0);
        }
    }
}

