/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class Misc {
    public static final UnaryOperator IDENTITY_OPERATOR = new UnaryOperator(){

        public Object operate(Object obj) {
            return obj;
        }
    };

    private Misc() {
    }

    public static String toString(double x, int sigFigs) {
        StringBuffer s;
        if (sigFigs < 1) {
            throw new IllegalArgumentException("sigFigs must be at least 1");
        }
        if (x == 0.0) {
            s = new StringBuffer("0");
            if (sigFigs > 1) {
                s.append(".");
                int i = 1;
                while (i < sigFigs) {
                    s.append("0");
                    ++i;
                }
            }
        } else {
            boolean negative = false;
            if (x < 0.0) {
                negative = true;
                x = -x;
            }
            double log10 = Math.log(10.0);
            int exp = (int)Math.floor(Math.log(x) / log10);
            s = new StringBuffer(sigFigs);
            long intVal = Math.round(x * Math.pow(10.0, sigFigs - exp - 1));
            String digits = Long.toString(intVal);
            if (digits.length() > sigFigs) {
                StringBuffer tmp = new StringBuffer(digits);
                tmp.setLength(sigFigs);
                digits = tmp.toString();
                ++exp;
            }
            int dIndex = 0;
            if (exp >= 0) {
                if (exp < sigFigs) {
                    s.append(digits.substring(0, exp + 1));
                    if ((dIndex += exp + 1) < sigFigs) {
                        s.append(".");
                    }
                    s.append(digits.substring(dIndex));
                } else {
                    s.append(digits);
                    int i = digits.length();
                    while (i <= exp) {
                        s.append('0');
                        ++i;
                    }
                }
            } else {
                s.append("0.");
                int i = -1;
                while (i > exp) {
                    s.append('0');
                    --i;
                }
                s.append(digits.substring(dIndex));
            }
            if (negative) {
                s.insert(0, '-');
            }
        }
        return s.toString();
    }

    public static Double[] promoteArray(double[] a) {
        Double[] result = new Double[a.length];
        int i = 0;
        while (i < a.length) {
            result[i] = new Double(a[i]);
            ++i;
        }
        return result;
    }

    public static Double[][] promoteMatrix(double[][] m) {
        Double[][] result = new Double[m.length][];
        int i = 0;
        while (i < m.length) {
            result[i] = Misc.promoteArray(m[i]);
            ++i;
        }
        return result;
    }

    public static int maxIndex(Number[] a) {
        if (a.length == 0) {
            return -1;
        }
        int result = 0;
        int i = 1;
        while (i < a.length) {
            if (a[i].doubleValue() > a[result].doubleValue()) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static int maxAbsIndex(Number[] a) {
        if (a.length == 0) {
            return -1;
        }
        int result = 0;
        int i = 1;
        while (i < a.length) {
            if (a[i].doubleValue() > Math.abs(a[result].doubleValue())) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static int sgn(double d) {
        return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
    }

    public static BitSet not(BitSet bs) {
        BitSet result = new BitSet(bs.size());
        int i = 0;
        while (i < bs.size()) {
            if (!bs.get(i)) {
                result.set(i);
            }
            ++i;
        }
        return result;
    }

    public static void shuffle(int[] a) {
        Misc.shuffle(a, new Random());
    }

    public static void shuffle(int[] a, Random r) {
        int i = a.length - 1;
        while (i > 0) {
            int j = (int)Math.floor(r.nextDouble() * (double)i);
            if (j != i) {
                int temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            --i;
        }
    }

    public static void shuffle(Object[] a) {
        Misc.shuffle(a, new Random());
    }

    public static void shuffle(Object[] a, Random r) {
        int i = a.length - 1;
        while (i > 0) {
            int j = (int)Math.floor(r.nextDouble() * (double)i);
            if (j != i) {
                Object temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            --i;
        }
    }

    public static void shuffle(Vector v) {
        Misc.shuffle(v, new Random());
    }

    public static void shuffle(Vector v, Random r) {
        int numElements = v.size();
        int i = numElements - 1;
        while (i > 0) {
            int j = (int)Math.floor(r.nextDouble() * (double)i);
            if (j != i) {
                Object temp = v.elementAt(i);
                v.setElementAt(v.elementAt(j), i);
                v.setElementAt(temp, j);
            }
            --i;
        }
    }

    public static void bitStringTest(String[] args) {
        if (args.length < 1) {
            System.err.println("Misc: usage: java Misc bitstring");
            System.exit(-1);
        }
        BitSet bs = new BitSet(args[0].length());
        int i = 0;
        while (i < args[0].length()) {
            if (args[0].charAt(i) == '1') {
                bs.set(i);
            }
            ++i;
        }
        System.out.println(String.valueOf(bs.toString()) + "\t" + Misc.not(bs).toString());
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Misc: usage: java Misc x sigFigs");
            System.exit(-1);
        }
        double x = Double.valueOf(args[0]);
        int sf = Integer.valueOf(args[1]);
        System.out.println(Misc.toString(x, sf));
    }

    public static String ordinalSuffix(int n) {
        String result;
        int ones = n % 10;
        switch (ones) {
            case 1: {
                result = "st";
                break;
            }
            case 2: {
                result = "nd";
                break;
            }
            case 3: {
                result = "rd";
                break;
            }
            default: {
                result = "th";
            }
        }
        return result;
    }

    public static String ordinal(int n) {
        return String.valueOf(n) + Misc.ordinalSuffix(n);
    }

    public static void printVector(PrintStream out, double[] v, int sigFigs) {
        out.print("{ ");
        int i = 0;
        while (i < v.length) {
            out.print(Misc.toString(v[i], sigFigs));
            if (i < v.length - 1) {
                out.print(", ");
            }
            ++i;
        }
        out.print(" }");
    }

    public static int indexOf(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == target) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Object findLargest(Collection collection, Comparator comp) {
        return Misc.findLargest(collection.iterator(), comp);
    }

    public static Object findLargest(Iterator iter, Comparator comp) {
        if (iter.hasNext()) {
            Object largest = iter.next();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (comp.compare(obj, largest) != 1) continue;
                largest = obj;
            }
            return largest;
        }
        return null;
    }

    public static Collection makeEmptyClone(Collection c) {
        ArrayList result = null;
        try {
            result = (ArrayList)c.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList(c.size());
        }
        return result;
    }

    public static Collection mapcar(Collection in, UnaryOperator op) {
        Collection result = Misc.makeEmptyClone(in);
        Iterator iter = in.iterator();
        while (iter.hasNext()) {
            result.add(op.operate(iter.next()));
        }
        return result;
    }

    public static List mapcar(Iterator iter, UnaryOperator op) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iter.hasNext()) {
            result.add(op.operate(iter.next()));
        }
        return result;
    }

    public static Collection accept(Collection in, Acceptor acceptor) {
        Collection result = Misc.makeEmptyClone(in);
        Iterator iter = in.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!acceptor.accept(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static Collection cloneCollection(Collection c) {
        return Misc.cloneCollection(c, false);
    }

    public static Object invokeClone(Object o) {
        Object result = null;
        try {
            Method cloneMethod = o.getClass().getDeclaredMethod("clone", null);
            try {
                result = cloneMethod.invoke(o, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException e) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    public static Collection cloneCollection(Collection c, boolean cloneMembers) {
        AbstractCollection result;
        if (cloneMembers) {
            result = Misc.mapcar(c, new UnaryOperator(){

                public Object operate(Object obj) {
                    Object newObj = obj == null ? obj : Misc.invokeClone(obj);
                    return newObj;
                }
            });
        } else {
            result = null;
            try {
                result = (Collection)c.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (result == null) {
                result = result instanceof Set ? new HashSet(c.size()) : new ArrayList(c.size());
            }
            result.addAll(c);
        }
        return result;
    }

    public static Object[] deepCopy(Object[] a) {
        Object[] result = (Object[])a.clone();
        int i = 0;
        while (i < a.length) {
            if (a[i] instanceof Collection) {
                result[i] = Misc.deepCopy((Collection)a[i]);
            } else if (a[i] instanceof Object[]) {
                result[i] = Misc.deepCopy((Object[])a[i]);
            } else {
                Object temp = Misc.invokeClone(a[i]);
                if (temp != null) {
                    result[i] = temp;
                }
            }
            ++i;
        }
        return result;
    }

    public static Collection deepCopy(Collection c) {
        ArrayList<Object[]> result = null;
        try {
            result = (ArrayList<Object[]>)c.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList<Object[]>(c.size());
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object temp;
            Object obj = iter.next();
            Object newObj = obj instanceof Collection ? Misc.deepCopy((Collection)obj) : (obj instanceof Object[] ? Misc.deepCopy((Object[])obj) : ((temp = Misc.invokeClone(obj)) != null ? temp : obj));
            result.add((Object[])newObj);
        }
        return result;
    }

    public static Object deepCopy(Object obj) {
        if (obj instanceof Collection) {
            return Misc.deepCopy((Collection)obj);
        }
        if (obj instanceof Object[]) {
            return Misc.deepCopy((Object[])obj);
        }
        if (obj instanceof Map) {
            return Misc.deepCopy((Map)obj);
        }
        Object newObj = Misc.invokeClone(obj);
        return newObj == null ? obj : newObj;
    }

    public static Map deepCopy(Map m) {
        HashMap<Object, Object> result = null;
        try {
            result = (HashMap<Object, Object>)m.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (result == null) {
            result = new HashMap<Object, Object>(m.size());
        }
        Set keys = m.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = m.get(key);
            result.put(Misc.deepCopy(key), Misc.deepCopy(value));
        }
        return result;
    }

    public static Map deepCopy(Map m, MapAcceptor acceptor) {
        HashMap<Object, Object> result = null;
        try {
            result = (HashMap<Object, Object>)m.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (result == null) {
            result = new HashMap<Object, Object>(m.size());
        }
        Set keys = m.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object value;
            Object key = iter.next();
            if (!acceptor.accept(key, value = m.get(key))) continue;
            result.put(Misc.deepCopy(key), Misc.deepCopy(value));
        }
        return result;
    }

    public static String escapeString(String s) {
        StringBuffer result = new StringBuffer();
        char[] c = s.toCharArray();
        result.append('\'');
        int i = 0;
        while (i < c.length) {
            switch (c[i]) {
                case '\'': 
                case '\\': {
                    result.append('\\');
                }
            }
            result.append(c[i]);
            ++i;
        }
        result.append('\'');
        return result.toString();
    }

    public static String readEscapedString(Reader reader) throws ParseException, IOException {
        return Misc.readEscapedString(reader, false);
    }

    public static String readEscapedString(Reader reader, boolean ignoreInitialWhitespace) throws ParseException, IOException {
        char c;
        StringBuffer result = new StringBuffer();
        boolean done = false;
        boolean validBeginning = false;
        if (ignoreInitialWhitespace) {
            while (!done) {
                c = (char)reader.read();
                if (Character.isSpaceChar(c)) continue;
                if (c == '\'') {
                    validBeginning = true;
                }
                done = true;
            }
            done = false;
        } else {
            boolean bl = validBeginning = reader.read() == 39;
        }
        if (!validBeginning) {
            throw new ParseException("First character was not a single quote (')", 0);
        }
        boolean escapeNextChar = false;
        while (!done) {
            c = (char)reader.read();
            if (escapeNextChar) {
                result.append(c);
                escapeNextChar = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escapeNextChar = true;
                    break;
                }
                case '\'': {
                    done = true;
                    break;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static boolean areEqualOrNull(String a, String b) {
        return a != null && a.equals(b) || a == null && b == null;
    }

    public static int sign(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    public interface UnaryOperator {
        public Object operate(Object var1);
    }

    public interface Acceptor {
        public boolean accept(Object var1);
    }

    public interface MapAcceptor {
        public boolean accept(Object var1, Object var2);
    }
}

