/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import edu.berkeley.guir.lib.gesture.util.Misc;
import java.util.BitSet;

public class Matrix {
    public static int sigFigs = 6;
    public static int width = 12;

    private Matrix() {
    }

    public static void prettyPrint(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                String s = Misc.toString(matrix[i][j], sigFigs);
                int foo = s.length();
                while (foo < width) {
                    System.out.print(" ");
                    ++foo;
                }
                System.out.print(s);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void prettyPrint(Double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                String s = Misc.toString(matrix[i][j], sigFigs);
                int foo = s.length();
                while (foo < width) {
                    System.out.print(" ");
                    ++foo;
                }
                System.out.print(s);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void prettyPrint(double[] vector) {
        double[][] m = new double[][]{vector};
        Matrix.prettyPrint((double[][])m);
    }

    public static void print(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        System.out.print("#MATRIX< ");
        int i = 0;
        while (i < rows) {
            System.out.print("( ");
            int j = 0;
            while (j < cols) {
                System.out.print(String.valueOf(matrix[i][j]) + " ");
                ++j;
            }
            System.out.print(")");
            ++i;
        }
        System.out.println(">");
    }

    public static double[][] transpose(double[][] matrix, boolean inPlace) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        if (!inPlace) {
            double[][] result = new double[cols][rows];
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < cols) {
                    result[j][i] = matrix[i][j];
                    ++j;
                }
                ++i;
            }
            return result;
        }
        if (rows != cols) {
            System.out.println("Transpose in place requires a square matrix");
        } else {
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < i) {
                    double dum = matrix[i][j];
                    matrix[i][j] = matrix[j][i];
                    matrix[j][i] = dum;
                    ++j;
                }
                ++i;
            }
        }
        return matrix;
    }

    public static double[][] add(double[][] arg1, double[][] arg2, double[][] result) {
        int rows = arg1.length;
        int cols = arg1[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = arg1[i][j] + arg2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] add(double[][] arg1, double[][] arg2) {
        int rows = arg1.length;
        int cols = arg1[0].length;
        double[][] result = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = arg1[i][j] + arg2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] subtract(double[][] arg1, double[][] arg2, double[][] result) {
        int rows = arg1.length;
        int cols = arg1[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = arg1[i][j] - arg2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] subtract(double[][] arg1, double[][] arg2) {
        int rows = arg1.length;
        int cols = arg1[0].length;
        double[][] result = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = arg1[i][j] - arg2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] multiply(double arg1, double[][] arg2, double[][] result) {
        int rows = arg2.length;
        int cols = arg2[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = arg1 * arg2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] multiply(double arg1, double[][] arg2) {
        int rows = arg2.length;
        int cols = arg2[0].length;
        double[][] result = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = arg1 * arg2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] multiply(double[][] arg1, double[][] arg2, double[][] result) {
        int i = 0;
        while (i < arg1.length) {
            int j = 0;
            while (j < arg2[0].length) {
                double sum = 0.0;
                int k = 0;
                while (k < arg1[0].length) {
                    sum += arg1[i][k] * arg2[k][j];
                    ++k;
                }
                result[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] multiply(double[][] arg1, double[][] arg2) {
        double[][] result = new double[arg1.length][arg2[0].length];
        int i = 0;
        while (i < arg1.length) {
            int j = 0;
            while (j < arg2[0].length) {
                double sum = 0.0;
                int k = 0;
                while (k < arg1[0].length) {
                    sum += arg1[i][k] * arg2[k][j];
                    ++k;
                }
                result[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double dotMultiply(double[][] arg1, double[][] arg2) {
        int i;
        double result = 0.0;
        if (arg2.length == 1) {
            i = 0;
            while (i < arg1.length) {
                result += arg1[i][0] * arg2[0][i];
                ++i;
            }
        }
        if (arg1.length == 1) {
            i = 0;
            while (i < arg2.length) {
                result += arg1[0][i] * arg2[i][0];
                ++i;
            }
        }
        return result;
    }

    public static double dotMultiply(double[] v1, double[] v2) {
        double result = 0.0;
        int i = 0;
        while (i < v1.length) {
            result += v1[i] * v2[i];
            ++i;
        }
        return result;
    }

    public static double[][] luDecompose(double[][] matrix, int[] indx, boolean parity) {
        int j;
        double amax;
        int n = matrix.length;
        int imax = 0;
        double dum = 0.0;
        double[] scaling = new double[n];
        double tiny = 1.0E-20;
        parity = true;
        int i = 0;
        while (i < n) {
            amax = 0.0;
            j = 0;
            while (j < n) {
                if (Math.abs(matrix[i][j]) > amax) {
                    amax = matrix[i][j];
                }
                ++j;
            }
            if (amax == 0.0) {
                System.err.println("Matrix.luDecompose: Singular Matrix");
            }
            scaling[i] = 1.0 / amax;
            ++i;
        }
        j = 0;
        while (j < n) {
            int k;
            i = 0;
            while (i < j) {
                dum = matrix[i][j];
                k = 0;
                while (k < i) {
                    dum -= matrix[i][k] * matrix[k][j];
                    ++k;
                }
                matrix[i][j] = dum;
                ++i;
            }
            amax = 0.0;
            i = j;
            while (i < n) {
                dum = matrix[i][j];
                k = 0;
                while (k < j) {
                    dum -= matrix[i][k] * matrix[k][j];
                    ++k;
                }
                matrix[i][j] = dum;
                if (scaling[i] * Math.abs(dum) > amax) {
                    amax = scaling[i] * Math.abs(dum);
                    imax = i;
                }
                ++i;
            }
            if (j != imax) {
                k = 0;
                while (k < n) {
                    dum = matrix[imax][k];
                    matrix[imax][k] = matrix[j][k];
                    matrix[j][k] = dum;
                    ++k;
                }
                parity = !parity;
                scaling[imax] = scaling[j];
            }
            indx[j] = imax;
            if (matrix[j][j] == 0.0) {
                matrix[j][j] = tiny;
            }
            if (j != n) {
                dum = 1.0 / matrix[j][j];
                i = j + 1;
                while (i < n) {
                    double[] dArray = matrix[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] * dum;
                    ++i;
                }
            }
            ++j;
        }
        return matrix;
    }

    public static double[][] luBackSubstitute(double[][] a, double[][] b, int[] indx) {
        int j;
        int n = a.length;
        int ii = -1;
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            int ip = indx[i];
            sum = b[ip][0];
            b[ip][0] = b[i][0];
            if (ii != -1) {
                j = ii;
                while (j < i) {
                    sum -= a[i][j] * b[j][0];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i][0] = sum;
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            sum = b[i][0];
            j = i + 1;
            while (j < n) {
                sum -= a[i][j] * b[j][0];
                ++j;
            }
            b[i][0] = sum / a[i][i];
            --i;
        }
        return b;
    }

    public static double[][] solve(double[][] a, double[][] b) {
        int size = a.length;
        boolean parity = true;
        int[] indx = new int[size];
        Matrix.luDecompose(a, indx, parity);
        Matrix.luBackSubstitute(a, b, indx);
        return b;
    }

    public static double[][] invert(double[][] arg) {
        int size = arg.length;
        double[][] col = new double[size][1];
        int[] indx = new int[size];
        double[][] result = new double[size][size];
        double[][] lud = new double[size][size];
        lud = Matrix.luDecompose(arg, indx, true);
        int j = 0;
        while (j < size) {
            int i = 0;
            while (i < size) {
                col[i][0] = 0.0;
                ++i;
            }
            col[j][0] = 1.0;
            Matrix.luBackSubstitute(lud, col, indx);
            i = 0;
            while (i < size) {
                result[i][j] = col[i][0];
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static double[][] clone(double[][] src) {
        double[][] result = new double[src.length][];
        int i = 0;
        while (i < src.length) {
            result[i] = (double[])src[i].clone();
            ++i;
        }
        return result;
    }

    public static double[][] safeInvert(double[][] m) {
        double[][] dummy = Matrix.clone(m);
        return Matrix.invert(dummy);
    }

    public static int bitcount(BitSet mask) {
        int result = 0;
        int i = 0;
        while (i < mask.size()) {
            if (mask.get(i)) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static double[][] slice(double[][] m, BitSet rowMask, BitSet colMask) {
        int nrows = m.length;
        int ncols = m[0].length;
        double[][] r = new double[nrows][ncols];
        int i = 0;
        int ri = 0;
        while (i < nrows) {
            if (rowMask.get(i)) {
                int j = 0;
                int rj = 0;
                while (j < ncols) {
                    if (colMask.get(j)) {
                        r[ri][rj++] = m[i][j];
                    }
                    ++j;
                }
                ++ri;
            }
            ++i;
        }
        return r;
    }

    public static double[][] deSlice(double[][] m, double fill, BitSet rowMask, BitSet colMask, double[][] r) {
        int nrows = m.length;
        int ncols = m[0].length;
        if (r == null) {
            r = new double[nrows][ncols];
        }
        Matrix.fill(r, fill);
        int i = 0;
        int ri = 0;
        while (i < nrows) {
            if (rowMask.get(i)) {
                int j = 0;
                int rj = 0;
                while (j < ncols) {
                    if (colMask.get(j)) {
                        r[i][j] = m[ri][rj++];
                    }
                    ++j;
                }
                ++ri;
            }
            ++i;
        }
        return r;
    }

    public static void fill(double[][] m, double fill) {
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length) {
                m[i][j] = fill;
                ++j;
            }
            ++i;
        }
    }

    public static double myInvert(double[][] ym, double[][] rm) {
        double hold;
        int j;
        int i;
        int[] l = new int[ym.length];
        int[] m = new int[ym.length];
        if (ym.length != ym[0].length) {
            System.err.println("myInvert: matrix not square");
            return Double.NaN;
        }
        int n = ym.length;
        if (n != rm.length || n != rm[0].length) {
            System.err.println("myInvert: result wrong size");
            return Double.NaN;
        }
        if (ym != rm) {
            i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    rm[i][j] = ym[i][j];
                    ++j;
                }
                ++i;
            }
        }
        double det = 1.0;
        int k = 0;
        while (k < n) {
            l[k] = k;
            m[k] = k;
            double biga = rm[k][k];
            i = k;
            while (i < n) {
                j = k;
                while (j < n) {
                    if (Math.abs(rm[i][j]) > Math.abs(biga)) {
                        biga = rm[i][j];
                        l[k] = i;
                        m[k] = j;
                    }
                    ++j;
                }
                ++i;
            }
            i = l[k];
            if (i > k) {
                j = 0;
                while (j < n) {
                    hold = -rm[k][j];
                    rm[k][j] = rm[i][j];
                    rm[i][j] = hold;
                    ++j;
                }
            }
            if ((j = m[k]) > k) {
                i = 0;
                while (i < n) {
                    hold = -rm[i][k];
                    rm[i][k] = rm[i][j];
                    rm[i][j] = hold;
                    ++i;
                }
            }
            if (biga == 0.0) {
                return 0.0;
            }
            double recip_biga = 1.0 / biga;
            i = 0;
            while (i < n) {
                if (i != k) {
                    double[] dArray = rm[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] * -recip_biga;
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                if (i != k) {
                    hold = rm[i][k];
                    j = 0;
                    while (j < n) {
                        if (j != k) {
                            double[] dArray = rm[i];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + hold * rm[k][j];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            j = 0;
            while (j < n) {
                if (j != k) {
                    double[] dArray = rm[k];
                    int n4 = j;
                    dArray[n4] = dArray[n4] * recip_biga;
                }
                ++j;
            }
            det *= biga;
            rm[k][k] = recip_biga;
            ++k;
        }
        k = n - 1;
        while (k >= 0) {
            i = l[k];
            if (i > k) {
                j = 0;
                while (j < n) {
                    hold = rm[j][k];
                    rm[j][k] = -rm[j][i];
                    rm[j][i] = hold;
                    ++j;
                }
            }
            if ((j = m[k]) > k) {
                i = 0;
                while (i < n) {
                    hold = rm[k][i];
                    rm[k][i] = -rm[j][i];
                    rm[j][i] = hold;
                    ++i;
                }
            }
            --k;
        }
        return det;
    }

    public static double QuadraticForm(double[] v, double[][] m) {
        double result = 0.0;
        int n = v.length;
        if (n != m.length || n != m[0].length) {
            System.err.println("Matrix.QuadraticForm: bad matrix size");
            return 0.0;
        }
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                result += m[i][j] * v[i] * v[j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] subtract(double[] v1, double[] v2) {
        double[] result = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            result[i] = v1[i] - v2[i];
            ++i;
        }
        return result;
    }

    public static double[] add(double[] v1, double[] v2) {
        double[] result = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            result[i] = v1[i] + v2[i];
            ++i;
        }
        return result;
    }

    public static double[] multiply(double factor, double[] v) {
        double[] result = new double[v.length];
        int i = 0;
        while (i < v.length) {
            result[i] = factor * v[i];
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        double[][] b = new double[][]{{6.0, 9.0, 3.0}, {-2.0, -1.0, 7.0}, {0.0, 1.0, 5.0}};
        Object d = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        System.out.println("b:");
        Matrix.print(b);
        System.out.println("inverse of b:");
        d = Matrix.safeInvert(b);
        Matrix.print(d);
        System.out.println("b:");
        Matrix.print(b);
    }
}

