/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import edu.berkeley.guir.lib.gesture.util.HystericResizer;
import edu.berkeley.guir.lib.gesture.util.awt;
import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;

public class FlowScrollPanel
extends JPanel
implements Scrollable {
    private FlowLayout layout = new FlowLayout();
    private JScrollPane scroller;
    static int buttonCount = 0;

    public FlowScrollPanel() {
        this((JScrollPane)null);
    }

    public FlowScrollPanel(JScrollPane scrollPane) {
        super.setLayout(this.layout);
        this.setScroller(scrollPane);
    }

    public void setScroller(JScrollPane scrollPane) {
        if (this.scroller != scrollPane) {
            this.scroller = scrollPane;
            if (this.scroller != null) {
                this.scroller.getViewport().setView(this);
            }
            this.scroller.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    FlowScrollPanel.this.scroller.getViewport().setViewSize(FlowScrollPanel.this.getSize());
                    FlowScrollPanel.this.scroller.invalidate();
                    FlowScrollPanel.this.scroller.validate();
                    FlowScrollPanel.this.doLayout();
                }
            });
        }
    }

    public Dimension getPreferredSize() {
        if (this.scroller == null) {
            Dimension result = super.getPreferredSize();
            return result;
        }
        Insets insets = this.getInsets();
        int hgap = this.layout.getHgap();
        int vgap = this.layout.getVgap();
        JScrollBar vsb = this.scroller.getVerticalScrollBar();
        if (vsb == null) {
            vsb = this.scroller.createVerticalScrollBar();
        }
        int scrollerWidth = this.scroller.getSize().width - (insets.left + insets.right + hgap * 2) - vsb.getSize().width;
        int nmembers = this.getComponentCount();
        int x = 0;
        int y = insets.top + vgap;
        int rowh = 0;
        int maxRowWidth = scrollerWidth;
        int i = 0;
        while (i < nmembers) {
            Component m = this.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                if (x == 0 || x + d.width <= scrollerWidth) {
                    if (x > 0) {
                        x += hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                } else {
                    if (x > maxRowWidth) {
                        maxRowWidth = x + hgap;
                    }
                    x = d.width;
                    y += vgap + rowh;
                    rowh = d.height;
                }
            }
            ++i;
        }
        if (x > maxRowWidth) {
            maxRowWidth = x + 2 * hgap + insets.left + insets.right;
        }
        return new Dimension(maxRowWidth, y += vgap + rowh + insets.bottom);
    }

    public void setLayout(LayoutManager l) {
        if (!(l instanceof FlowLayout)) {
            throw new AWTError("FlowScrollPane can have only FlowLayout, not " + l);
        }
        this.layout = (FlowLayout)l;
        super.setLayout(l);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension prefSize = this.layout.preferredLayoutSize(this);
        return prefSize.height;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("FlowScrollPanel test");
        Container contents = frame.getContentPane();
        FlowScrollPanel panel = new FlowScrollPanel();
        JScrollPane scrollPane = new JScrollPane(panel);
        panel.setScroller(scrollPane);
        panel.setBackground(Color.white);
        scrollPane.setBackground(Color.yellow);
        contents.setLayout(new BorderLayout());
        contents.add((Component)scrollPane, "Center");
        JPanel controlPanel = new JPanel();
        JButton button = new JButton("add");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlowScrollPanel.addButton(FlowScrollPanel.this);
                frame.pack();
            }
        });
        controlPanel.add(button);
        controlPanel.setBackground(Color.blue);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Quit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(item);
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        contents.add((Component)controlPanel, "South");
        FlowScrollPanel.addButton(panel);
        FlowScrollPanel.addButton(panel);
        FlowScrollPanel.addButton(panel);
        HystericResizer hr = new HystericResizer();
        frame.getRootPane().addComponentListener(hr);
        frame.pack();
        frame.show();
    }

    static void addButton(final JComponent parent) {
        final JButton b = new JButton("Button " + ++buttonCount);
        parent.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parent.remove(b);
                awt.getWindow(parent).pack();
            }
        });
    }
}

