/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import edu.berkeley.guir.lib.gesture.util.CTableModel;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class DefaultCTableModel
extends DefaultTableModel
implements CTableModel {
    protected Vector rowIdentifiers;

    public DefaultCTableModel() {
        super((Vector<?>)null, 0);
        this.initRowIdentifiers(0);
    }

    public DefaultCTableModel(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initRowIdentifiers(numRows);
    }

    protected void initRowIdentifiers(int numRows) {
        this.rowIdentifiers = new Vector(numRows);
        this.rowIdentifiers.setSize(numRows);
    }

    public String getRowName(int row) {
        Object id;
        String result = row < this.rowIdentifiers.size() ? ((id = this.rowIdentifiers.elementAt(row)) == null ? null : id.toString()) : null;
        return result;
    }

    public void setRowName(int rowNumber, Object newName) {
        if (rowNumber >= this.rowIdentifiers.size()) {
            throw new ArrayIndexOutOfBoundsException(rowNumber);
        }
        this.rowIdentifiers.setElementAt(newName, rowNumber);
    }

    public void addRow(Vector rowData) {
        this.addRow(null, rowData);
    }

    public void addRow(Object[] rowData) {
        this.addRow(null, DefaultTableModel.convertToVector(rowData));
    }

    public void addRow(Object rowName, Vector rowData) {
        super.addRow(rowData);
        this.rowIdentifiers.addElement(rowName);
    }

    public void insertRow(int row, Vector rowData) {
        this.insertRow(row, null, rowData);
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, null, DefaultTableModel.convertToVector(rowData));
    }

    public void insertRow(int row, Object rowName, Vector rowData) {
        super.insertRow(row, rowData);
        this.rowIdentifiers.insertElementAt(rowName, row);
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        super.moveRow(startIndex, endIndex, toIndex);
        if (startIndex <= toIndex && toIndex <= endIndex) {
            return;
        }
        boolean shift = toIndex < startIndex;
        int i = startIndex;
        while (i <= endIndex) {
            Object rowName = this.rowIdentifiers.elementAt(i);
            this.rowIdentifiers.removeElementAt(i);
            this.rowIdentifiers.insertElementAt(rowName, toIndex);
            if (shift) {
                ++toIndex;
            }
            ++i;
        }
    }

    public void removeRow(int row) {
        super.removeRow(row);
        this.rowIdentifiers.removeElementAt(row);
    }
}

