/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class CompositeIcon
implements Icon {
    List icons;

    public CompositeIcon() {
        this(new ArrayList());
    }

    public CompositeIcon(List iconList) {
        this.icons = iconList;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Iterator iter = this.icons.iterator();
        while (iter.hasNext()) {
            Icon icon = (Icon)iter.next();
            icon.paintIcon(c, g, x, y);
            x += icon.getIconWidth();
        }
    }

    public int getIconHeight() {
        int maxHeight = 0;
        Iterator iter = this.icons.iterator();
        while (iter.hasNext()) {
            Icon icon = (Icon)iter.next();
            maxHeight = Math.max(icon.getIconHeight(), maxHeight);
        }
        return maxHeight;
    }

    public int getIconWidth() {
        int width = 0;
        Iterator iter = this.icons.iterator();
        while (iter.hasNext()) {
            Icon icon = (Icon)iter.next();
            width += icon.getIconWidth();
        }
        return width;
    }

    public void add(Icon icon) {
        this.icons.add(icon);
    }

    public void clear() {
        this.icons.clear();
    }
}

