/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import java.util.Collection;
import java.util.EventObject;

public class CollectionEvent
extends EventObject {
    public static final int ELEMENT_ADDED = 0;
    public static final int ELEMENT_REMOVED = 1;
    public static final int ELEMENT_CHANGED = 2;
    private int type;
    private Object[] elements;
    private int startIndex;

    public CollectionEvent(Object source, int eventType, Object element, int startIndex) {
        super(source);
        Object[] elements = new Object[]{element};
        this.init(eventType, elements, startIndex);
    }

    public CollectionEvent(Object source, int eventType, Object[] elements, int startIndex) {
        super(source);
        this.init(eventType, elements, startIndex);
    }

    public CollectionEvent(Object source, int eventType, Collection elements, int startIndex) {
        this(source, eventType, elements.toArray(), startIndex);
    }

    private void init(int eventType, Object[] elements, int startIndex) {
        this.type = eventType;
        this.elements = elements;
        this.startIndex = startIndex;
    }

    public Object getElement() {
        return this.elements[0];
    }

    public Object[] getElements() {
        return this.elements;
    }

    public int getElementCount() {
        return this.elements.length;
    }

    public int getType() {
        return this.type;
    }

    public int getStartIndex() {
        return this.startIndex;
    }
}

