/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import edu.berkeley.guir.lib.gesture.util.CTableModel;
import edu.berkeley.guir.lib.gesture.util.DefaultCTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CTable
extends JTable {
    protected JList rowHeader;
    protected ListModel rowHeaderModel;
    static /* synthetic */ Class class$0;

    public CTable() {
        this(null, null, null);
    }

    public CTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initUI();
    }

    public CTable(CTableModel dm) {
        super(dm);
        this.initUI();
    }

    public CTable(CTableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initUI();
    }

    public CTable(CTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initUI();
    }

    protected void initUI() {
        this.buildRowHeaders();
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultCTableModel();
    }

    protected void buildRowHeaders() {
        if (this.rowHeader == null) {
            this.rowHeaderModel = new AbstractListModel(){

                public int getSize() {
                    return CTable.this.getModel() == null ? 0 : CTable.this.getModel().getRowCount();
                }

                public Object getElementAt(int index) {
                    CTableModel dm = (CTableModel)CTable.this.getModel();
                    if (dm == null) {
                        return null;
                    }
                    return dm.getRowName(index);
                }
            };
            this.rowHeader = new JList(this.rowHeaderModel);
            this.rowHeader.setSelectionModel(this.getSelectionModel());
            this.rowHeader.setFixedCellWidth(50);
            JTableHeader columnHeader = this.getTableHeader();
            this.rowHeader.setForeground(columnHeader.getForeground());
            this.rowHeader.setBackground(columnHeader.getBackground());
            this.rowHeader.setFont(columnHeader.getFont());
            this.rowHeader.setFixedCellHeight(this.getRowHeight() + this.getRowMargin());
            this.rowHeader.setCellRenderer(new RowHeaderRenderer());
            columnHeader.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    try {
                        String string = event.getPropertyName();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("javax.swing.JList");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PropertyDescriptor propDesc = new PropertyDescriptor(string, clazz);
                        Method writeMethod = propDesc.getWriteMethod();
                        Object[] params = new Object[]{event.getNewValue()};
                        writeMethod.invoke((Object)CTable.this.rowHeader, params);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected void configureEnclosingScrollPane() {
        Container grandParent;
        super.configureEnclosingScrollPane();
        Container parent = this.getParent();
        if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)grandParent;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    public String getRowName(int row) {
        return ((CTableModel)this.getModel()).getRowName(row);
    }

    public static void main(String[] args) {
        DefaultCTableModel tm = new DefaultCTableModel(5, 5);
        CTable t = new CTable(tm);
        JFrame f = new JFrame("CTable test");
        int i = 0;
        while (i < 5) {
            tm.setRowName(i, "#" + i);
            ++i;
        }
        f.getContentPane().add(new JScrollPane(t));
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.pack();
        f.show();
    }

    class RowHeaderRenderer
    implements ListCellRenderer {
        Border border;
        Color foreground;
        Color background;
        Font font;

        RowHeaderRenderer() {
            JTableHeader header = CTable.this.getTableHeader();
            this.border = UIManager.getBorder("TableHeader.cellBorder");
            this.foreground = header.getForeground();
            this.background = header.getBackground();
            this.font = header.getFont();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result;
            if (value instanceof Component) {
                result = (Component)value;
            } else {
                JLabel label = new JLabel(value == null ? "" : value.toString());
                label.setOpaque(true);
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                label.setBackground(this.background);
                label.setBorder(this.border);
                label.setFont(this.font);
                result = label;
            }
            return result;
        }
    }
}

