/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.util;

import edu.berkeley.guir.lib.gesture.util.awt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class Blinker
extends JComponent
implements ActionListener {
    protected Color onColor = Color.green;
    protected Color offColor = Color.black;
    private boolean isOn = false;
    private Timer timer = new Timer(2000, this);

    public Blinker() {
        this.timer.start();
    }

    public Color getOnColor() {
        return this.onColor;
    }

    public void setOnColor(Color color) {
        if (this.onColor != color) {
            this.onColor = color;
            if (this.isOn) {
                this.repaint();
            }
        }
    }

    public Color getOffColor() {
        return this.offColor;
    }

    public void setOffColor(Color color) {
        if (this.offColor != color) {
            this.offColor = color;
            if (!this.isOn) {
                this.repaint();
            }
        }
    }

    public boolean isOn() {
        return this.isOn;
    }

    public void setOn(boolean on) {
        if (on != this.isOn) {
            this.isOn = on;
            this.repaint();
        }
    }

    public void toggle() {
        this.setOn(!this.isOn());
    }

    public void actionPerformed(ActionEvent e) {
        this.toggle();
    }

    protected void paintComponent(Graphics oldGraphics) {
        Graphics g = oldGraphics.create();
        g.setColor(this.isOn ? this.onColor : this.offColor);
        Dimension size = awt.sizeWithInsets(g, this);
        g.fillOval(0, 0, size.width, size.height);
    }
}

