/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;

public class TotalLength
extends Feature {
    public final double minValue = 0.0;
    public final double maxValue = Double.POSITIVE_INFINITY;

    public TotalLength() {
    }

    public TotalLength(Gesture g) {
        super(g);
    }

    public String getName() {
        return new String("total length");
    }

    public double getMinValue() {
        return 0.0;
    }

    public double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    protected void computeValue() {
        TimedPolygon points = this.gesture.getPointsRef();
        this.value = 0.0;
        int i = 1;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double magsq = dx * dx + dy * dy;
            this.value += Math.sqrt(magsq);
            ++i;
        }
        this.valueOk = true;
    }

    public void scale(double factor) {
        this.gesture.normalize();
        TimedPolygon points = this.gesture.getPoints();
        int i = 0;
        while (i < points.npoints) {
            int n = i;
            points.xpoints[n] = (int)((double)points.xpoints[n] * factor);
            int n2 = i++;
            points.ypoints[n2] = (int)((double)points.ypoints[n2] * factor);
        }
        this.gesture.setPoints(points);
    }
}

