/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;

public class TotalAngle
extends Feature {
    public final double minValue = Double.NEGATIVE_INFINITY;
    public final double maxValue = Double.POSITIVE_INFINITY;

    public TotalAngle() {
    }

    public TotalAngle(Gesture g) {
        super(g);
    }

    public String getName() {
        return new String("total angle");
    }

    public double getMinValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    protected void computeValue() {
        TimedPolygon points = this.gesture.getPointsRef();
        this.value = 0.0;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            this.value += theta;
            ++i;
        }
        this.valueOk = true;
    }

    public void scale(double factor) {
    }
}

