/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import java.awt.Rectangle;

public class LogAspect
extends Feature {
    protected static final double RADIANS45 = 0.7853981633974483;
    protected static final double ONE_DEGREE = Math.PI / 180;

    public LogAspect() {
    }

    public LogAspect(Gesture g) {
        super(g);
    }

    public String getName() {
        return "log(aspect)";
    }

    public double getMinValue() {
        return Double.MIN_VALUE;
    }

    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    protected void computeValue() {
        Rectangle bounds = this.gesture.getBounds();
        double boundsAngle = Math.atan2(bounds.height, bounds.width);
        double aspect = Math.abs(boundsAngle - 0.7853981633974483);
        this.value = Math.log(aspect != 0.0 ? aspect : Math.PI / 180);
        this.valueOk = true;
    }

    public void scale(double factor) {
    }
}

