/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;

public class InitAngleCosine
extends Feature {
    public double minValue = -1.0;
    public double maxValue = 1.0;

    public InitAngleCosine() {
    }

    public InitAngleCosine(Gesture g) {
        super(g);
    }

    protected void computeValue() {
        double y0;
        double y2;
        double x0;
        double x2;
        double hypot;
        TimedPolygon p = this.gesture.getPointsRef();
        this.value = p.npoints < 3 ? 0.0 : ((hypot = Math.sqrt(((x2 = (double)p.xpoints[2]) - (x0 = (double)p.xpoints[0])) * (x2 - x0) + ((y2 = (double)p.ypoints[2]) - (y0 = (double)p.ypoints[0])) * (y2 - y0))) == 0.0 ? 0.0 : (x2 - x0) / hypot);
        this.valueOk = true;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public String getName() {
        return new String("cosine of initial angle");
    }

    public void scale(double factor) {
        this.gesture.normalize();
        TimedPolygon points = this.gesture.getPoints();
        double delta = (double)(points.xpoints[2] - points.xpoints[0]) * factor;
        points.xpoints[0] = (int)((double)points.xpoints[0] + delta);
        this.gesture.setPoints(points);
    }
}

