/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;

public class EndsDistance
extends Feature {
    public final double minValue = 0.0;
    public final double maxValue = Double.POSITIVE_INFINITY;

    public EndsDistance() {
    }

    public EndsDistance(Gesture g) {
        super(g);
    }

    protected void computeValue() {
        TimedPolygon points = this.gesture.getPointsRef();
        if (points.npoints > 0) {
            double dx = points.xpoints[points.npoints - 1] - points.xpoints[0];
            double dy = points.ypoints[points.npoints - 1] - points.ypoints[0];
            this.value = Math.sqrt(dx * dx + dy * dy);
        } else {
            this.value = 0.0;
        }
        this.valueOk = true;
    }

    public String getName() {
        return new String("distance between first and last points");
    }

    public double getMinValue() {
        return 0.0;
    }

    public double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    public void scale(double factor) {
        this.gesture.normalize();
        TimedPolygon points = this.gesture.getPointsRef();
        int i = 0;
        while (i < points.npoints) {
            int n = i;
            points.xpoints[n] = (int)((double)points.xpoints[n] * factor);
            int n2 = i++;
            points.ypoints[n2] = (int)((double)points.ypoints[n2] * factor);
        }
        this.gesture.setPoints(points);
    }
}

