/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;

public class EndsAngleSine
extends Feature {
    public double minValue = -1.0;
    public double maxValue = 1.0;
    double rolloff = 16.0;
    double EPSILON = 1.0E-4;

    public EndsAngleSine() {
    }

    public EndsAngleSine(Gesture g) {
        super(g);
    }

    protected void computeValue() {
        TimedPolygon p = this.gesture.getPointsRef();
        if (p.npoints < 3) {
            this.value = 0.0;
        } else {
            double xn = p.xpoints[p.npoints - 1];
            double x0 = p.xpoints[0];
            double yn = p.ypoints[p.npoints - 1];
            double y0 = p.ypoints[0];
            double hypot = Math.sqrt((xn - x0) * (xn - x0) + (yn - y0) * (yn - y0));
            double factor = hypot * hypot / this.rolloff;
            if (factor > 1.0) {
                factor = 1.0;
            }
            factor = hypot > this.EPSILON ? factor / hypot : 0.0;
            this.value = (yn - y0) * factor;
        }
        this.valueOk = true;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public String getName() {
        return new String("sine of angle between first and last points");
    }

    public void scale(double factor) {
        this.gesture.normalize();
        TimedPolygon points = this.gesture.getPoints();
        double y0 = points.ypoints[0];
        double yn = points.ypoints[points.npoints - 1];
        boolean scaley = (factor - 1.0) * (yn - y0) > 0.0;
        double f = factor >= 1.0 ? factor : 1.0 / factor;
        int i = 0;
        while (i < points.npoints) {
            if (scaley) {
                int n = i;
                points.ypoints[n] = (int)((double)points.ypoints[n] * f);
            } else {
                int n = i;
                points.xpoints[n] = (int)((double)points.xpoints[n] * f);
            }
            ++i;
        }
        this.gesture.setPoints(points);
    }
}

