/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import java.awt.Rectangle;

public class BoundsSize
extends Feature {
    public final double minValue = 0.0;
    public final double maxValue = Double.POSITIVE_INFINITY;

    public BoundsSize() {
    }

    public BoundsSize(Gesture g) {
        super(g);
    }

    protected void computeValue() {
        Rectangle bounds = this.gesture.getBounds();
        this.value = Math.sqrt(bounds.width * bounds.width + bounds.height * bounds.height);
        this.valueOk = true;
    }

    public String getName() {
        return new String("size of bounding box");
    }

    public double getMinValue() {
        return 0.0;
    }

    public double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    public void scale(double factor) {
        this.gesture.normalize();
        TimedPolygon points = this.gesture.getPointsRef();
        int i = 0;
        while (i < points.npoints) {
            int n = i;
            points.xpoints[n] = (int)((double)points.xpoints[n] * factor);
            int n2 = i++;
            points.ypoints[n2] = (int)((double)points.ypoints[n2] * factor);
        }
        this.gesture.setPoints(points);
    }
}

