/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.features;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import java.awt.Rectangle;

public class BoundsAngle
extends Feature {
    public final double minValue = 0.0;
    public final double maxValue = 1.5707963267948966;

    public BoundsAngle() {
    }

    public BoundsAngle(Gesture g) {
        super(g);
    }

    protected void computeValue() {
        Rectangle bounds = this.gesture.getBounds();
        this.value = Math.atan2(bounds.height, bounds.width);
        this.valueOk = true;
    }

    public String getName() {
        return new String("angle of bounding box");
    }

    public double getMinValue() {
        return 0.0;
    }

    public double getMaxValue() {
        return 1.5707963267948966;
    }

    public void scale(double factor) {
        this.gesture.normalize();
        TimedPolygon points = this.gesture.getPointsRef();
        int i = 0;
        while (i < points.npoints) {
            if (factor < 1.0) {
                int n = i;
                points.ypoints[n] = (int)((double)points.ypoints[n] / factor);
            } else {
                int n = i;
                points.xpoints[n] = (int)((double)points.xpoints[n] * factor);
            }
            ++i;
        }
        this.gesture.setPoints(points);
    }
}

