/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.voodoo;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GesturePointsDisplay;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class VGesturePointsDisplay
extends GesturePointsDisplay {
    public static double straightThreshold = 0.08726646259971647;
    public static double cornerThreshold = 1.0471975511965976;
    public static Color straightColor = Color.red;
    public static Color curvyColor = Color.blue;

    public VGesturePointsDisplay() {
        super((Gesture)null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        TimedPolygon points;
        super.paint(graphics);
        if (this.getGesture() == null) return;
        Dimension size = this.getSize();
        if (this.isSelected && this.showSelected) {
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        if ((points = this.getGesture().getPoints()) == null) return;
        if (points.npoints <= 0) return;
        double straightLen = 0.0;
        double curvyLen = 0.0;
        Insets insets = this.getInsets();
        Graphics g = graphics.create();
        try {
            g.clipRect(insets.left, insets.top, size.width - insets.right, size.height - insets.bottom);
            g.translate(this.xoffset + insets.left, this.yoffset + insets.top);
            g.setColor(Color.black);
            Graphics pointsGraphics = null;
            try {
                String percentStr;
                int numPoints;
                if (this.showPointsOn) {
                    pointsGraphics = g.create();
                    pointsGraphics.setColor(Color.white);
                }
                g.fillOval(points.xpoints[0] - 3, points.ypoints[0] - 3, 6, 6);
                int n = numPoints = this.animate ? this.animatePoints : points.npoints;
                if (numPoints > 1) {
                    g.drawLine(points.xpoints[0], points.ypoints[0], (points.xpoints[0] + points.xpoints[1]) / 2, (points.ypoints[0] + points.ypoints[1]) / 2);
                    int i = 1;
                    while (true) {
                        if (i >= numPoints - 1) {
                            g.drawLine((points.xpoints[numPoints - 2] + points.xpoints[numPoints - 1]) / 2, (points.ypoints[numPoints - 2] + points.ypoints[numPoints - 1]) / 2, points.xpoints[numPoints - 1], points.ypoints[numPoints - 1]);
                            break;
                        }
                        boolean straight = this.isStraight(i);
                        g.setColor(straight ? straightColor : curvyColor);
                        double segmentLen = (this.dist(i - 1, i) + this.dist(i, i + 1)) / 2.0;
                        if (straight) {
                            straightLen += segmentLen;
                        } else {
                            curvyLen += segmentLen;
                        }
                        g.drawLine((points.xpoints[i - 1] + points.xpoints[i]) / 2, (points.ypoints[i - 1] + points.ypoints[i]) / 2, points.xpoints[i], points.ypoints[i]);
                        g.drawLine(points.xpoints[i], points.ypoints[i], (points.xpoints[i] + points.xpoints[i + 1]) / 2, (points.ypoints[i] + points.ypoints[i + 1]) / 2);
                        if (this.showPointsOn) {
                            pointsGraphics.fillOval(points.xpoints[i] - 1, points.ypoints[i] - 1, 3, 3);
                        }
                        ++i;
                    }
                }
                if (this.showPointsOn && numPoints > 0) {
                    pointsGraphics.drawLine(points.xpoints[numPoints - 1], points.ypoints[numPoints - 1], points.xpoints[numPoints - 1], points.ypoints[numPoints - 1]);
                }
                double totalLen = straightLen + curvyLen;
                if (straightLen > curvyLen) {
                    g.setColor(straightColor);
                    percentStr = Misc.toString(straightLen / totalLen, 2);
                } else {
                    g.setColor(curvyColor);
                    percentStr = Misc.toString(curvyLen / totalLen, 2);
                }
                g.drawString(percentStr, 0, 0);
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (!this.showPointsOn) throw throwable;
                pointsGraphics.dispose();
                throw throwable;
            }
            {
                Object var16_17 = null;
                if (this.showPointsOn) {
                    pointsGraphics.dispose();
                }
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            g.dispose();
            throw throwable;
        }
        {
            Object var18_20 = null;
            g.dispose();
            return;
        }
    }

    boolean isStraight(int index) {
        double theta = this.computeAngle(index);
        return theta < straightThreshold || theta > cornerThreshold;
    }

    double computeAngle(int index) {
        TimedPolygon points = this.getGesture().getPoints();
        double Ax = points.xpoints[index] - points.xpoints[index - 1];
        double Ay = points.ypoints[index] - points.ypoints[index - 1];
        double Bx = points.xpoints[index + 1] - points.xpoints[index];
        double By = points.ypoints[index + 1] - points.ypoints[index];
        double magA = Math.sqrt(Ax * Ax + Ay * Ay);
        double magB = Math.sqrt(Bx * Bx + By * By);
        double dotProduct = (Ax * Bx + Ay * By) / (magA * magB);
        double theta = Math.acos(dotProduct);
        return theta;
    }

    double dist(int i, int j) {
        TimedPolygon points = this.getGesture().getPoints();
        int dx = points.xpoints[i] - points.xpoints[j];
        int dy = points.ypoints[i] - points.ypoints[j];
        return Math.sqrt(dx * dx + dy * dy);
    }
}

