/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.voodoo;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.GestureSetFrame;
import edu.berkeley.guir.lib.gesture.apps.voodoo.Curviness;
import java.io.File;
import java.io.PrintStream;

public class Curviness2 {
    static final String progName = "curviness";
    static final String usage = "usage: curviness [-max #] [gesturefile]";

    public static void main(String[] argv) {
        int i = 0;
        while (i < argv.length && argv[i].charAt(i) == '-') {
            if (argv[i].equals("-max")) {
                try {
                    if (++i >= argv.length) {
                        Curviness2.error(usage);
                        System.exit(-1);
                    }
                    Double d = Double.valueOf(argv[i]);
                    Curviness.threshold = d;
                }
                catch (NumberFormatException e) {
                    Curviness2.error("invalid number: " + argv[i]);
                    System.exit(-1);
                }
            } else {
                Curviness2.error("Unknown option: " + argv[i]);
                Curviness2.error(usage);
                System.exit(-1);
            }
            ++i;
        }
        if (i >= argv.length) {
            Curviness2.error(usage);
            System.exit(-1);
        }
        GestureSetFrame frame = new GestureSetFrame(progName, false);
        while (i < argv.length) {
            frame.openFile(new File(argv[i]));
            GestureSet gs = frame.getGestureSetDisplay().getGestureSet();
            Curviness2.printFeatureVals(System.out, gs);
            ++i;
        }
        System.exit(0);
    }

    static void printFeatureVals(PrintStream out, GestureSet gs) {
        int catNum = 0;
        while (catNum < gs.size()) {
            GestureCategory gc = (GestureCategory)gs.getCategories().get(catNum);
            out.print(gc.getName());
            double average1 = 0.0;
            double average2 = 0.0;
            int gNum = 0;
            while (gNum < gc.size()) {
                Gesture g = gc.gestureAt(gNum);
                Curviness f = new Curviness(g);
                average1 += f.getValue();
                average2 += f.getValue();
                ++gNum;
            }
            out.println("\t" + average1 / (double)gc.size() + "\t" + average2 / (double)gc.size());
            ++catNum;
        }
    }

    static void error(String message) {
        System.err.println("curviness: " + message);
    }
}

