/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.voodoo;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;

public class Curviness
extends Feature {
    public static double threshold = 19.0;

    public Curviness() {
    }

    public Curviness(Gesture g) {
        super(g);
    }

    public String getName() {
        return "curviness";
    }

    public double getMinValue() {
        return 0.0;
    }

    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    protected void computeValue() {
        TimedPolygon points = this.gesture.getPoints();
        this.value = 0.0;
        double thresholdRadians = threshold / 180.0 * Math.PI;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            if (Math.abs(theta) < thresholdRadians) {
                this.value += theta;
            }
            ++i;
        }
        this.value = Math.abs(this.value);
        this.valueOk = true;
    }

    public void scale(double factor) {
    }
}

