/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.triad;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TriadLayout
implements LayoutManager2 {
    static final double sqrt2 = Math.sqrt(2.0);
    Vector components = new Vector(3);
    int spacing;

    public TriadLayout() {
        this(5);
    }

    public TriadLayout(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException(this + ":inter-child spacing must be >= 0.");
        }
        this.spacing = spacing;
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null && constraints instanceof Integer) {
            int index = (Integer)constraints;
            if (index < 0 || index > 2) {
                throw new IllegalArgumentException(this + " can only have 3 children");
            }
            this.components.setElementAt(comp, index);
        } else {
            if (this.components.size() >= 3) {
                throw new IllegalArgumentException(this + " can only have 3 children");
            }
            this.components.addElement(comp);
        }
    }

    public void removeLayoutComponent(Component comp) {
        this.components.removeElement(comp);
    }

    private int computeRadius() {
        Component c1 = null;
        Component c2 = null;
        Component c3 = null;
        Dimension dim1 = null;
        Dimension dim2 = null;
        Dimension dim3 = null;
        int w1 = 0;
        int w2 = 0;
        int w3 = 0;
        int h1 = 0;
        int h2 = 0;
        int h3 = 0;
        int size = this.components.size();
        switch (size) {
            case 3: {
                c3 = (Component)this.components.elementAt(2);
                dim3 = c3.getPreferredSize();
                w3 = dim3.width;
                h3 = dim3.height;
            }
            case 2: {
                c2 = (Component)this.components.elementAt(1);
                dim2 = c2.getPreferredSize();
                w2 = dim2.width;
                h2 = dim2.height;
            }
            case 1: {
                c1 = (Component)this.components.elementAt(0);
                dim1 = c1.getPreferredSize();
                w1 = dim1.width;
                h1 = dim1.height;
                break;
            }
            case 0: {
                return 0;
            }
            default: {
                throw new RuntimeException(this + " has too many children!");
            }
        }
        int radius = (int)Math.round((double)(w1 + w2 + 2 * this.spacing) / sqrt2);
        int r = (int)Math.round(Math.min((double)(w1 + w3 + 2 * this.spacing) / sqrt2, (double)(h1 + h3 + 2 * this.spacing) / 3.0));
        if (r > radius) {
            radius = r;
        }
        if ((r = (int)Math.round(Math.min((double)(w2 + w3 + 2 * this.spacing) / sqrt2, (double)(h2 + h3 + 2 * this.spacing) / 3.0))) > radius) {
            radius = r;
        }
        return radius;
    }

    public Dimension preferredLayoutSize(Container parent) {
        int radius = this.computeRadius();
        Insets insets = parent.getInsets();
        int width = insets.left + insets.right;
        int height = insets.top + insets.bottom;
        Component c1 = null;
        Component c2 = null;
        Component c3 = null;
        Dimension dim1 = null;
        Dimension dim2 = null;
        Dimension dim3 = null;
        int w1 = 0;
        int w2 = 0;
        int w3 = 0;
        int h1 = 0;
        int h2 = 0;
        int h3 = 0;
        int size = this.components.size();
        switch (size) {
            case 3: {
                c3 = (Component)this.components.elementAt(2);
                dim3 = c3.getPreferredSize();
                w3 = dim3.width;
                h3 = dim3.height;
            }
            case 2: {
                c2 = (Component)this.components.elementAt(1);
                dim2 = c2.getPreferredSize();
                w2 = dim2.width;
                h2 = dim2.height;
            }
            case 1: {
                c1 = (Component)this.components.elementAt(0);
                dim1 = c1.getPreferredSize();
                w1 = dim1.width;
                h1 = dim1.height;
                break;
            }
            case 0: {
                return new Dimension(width, height);
            }
            default: {
                throw new RuntimeException(this + " has too many elements!");
            }
        }
        width = (int)((long)width + Math.max((long)w3, Math.round((double)radius * sqrt2) + (long)Math.max(w1, w2)));
        return new Dimension(width, height += 2 * Math.max(Math.max(h1, h2) + Math.round(radius / 2), radius + h3 / 2));
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension parentSize = parent.getSize();
        int radius = this.computeRadius();
        int centerX = parentSize.width / 2 + insets.left;
        int centerY = parentSize.height / 2 + insets.top;
        Component c1 = null;
        Component c2 = null;
        Component c3 = null;
        Dimension dim1 = null;
        Dimension dim2 = null;
        Dimension dim3 = null;
        int size = this.components.size();
        switch (size) {
            case 3: {
                c3 = (Component)this.components.elementAt(2);
                dim3 = c3.getPreferredSize();
                c3.setSize(dim3);
                TriadLayout.setCenter(c3, centerX, centerY + radius);
            }
            case 2: {
                c2 = (Component)this.components.elementAt(1);
                dim2 = c2.getPreferredSize();
                c2.setSize(dim2);
                TriadLayout.setCenter(c2, centerX + (int)Math.round((double)radius / sqrt2), centerY - radius / 2);
            }
            case 1: {
                c1 = (Component)this.components.elementAt(0);
                dim1 = c1.getPreferredSize();
                c1.setSize(dim1);
                TriadLayout.setCenter(c1, centerX - (int)Math.round((double)radius / sqrt2), centerY - radius / 2);
                break;
            }
            case 0: {
                return;
            }
            default: {
                throw new RuntimeException(this + " has too many elements!");
            }
        }
    }

    static void setCenter(Component c, int x, int y) {
        Dimension size = c.getSize();
        c.setLocation(x - size.width / 2, y - size.height / 2);
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("TriadLayout test");
        JPanel contents = new JPanel();
        contents.setLayout(new TriadLayout());
        contents.add(new JButton("1 fooalksjdflakjssf"));
        contents.add(new JButton("2 barsldkfjslkdfjsl"));
        contents.add(new JButton("3 ishslkdfjsldkjsl1"));
        contents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        f.addWindowListener(l);
        f.getContentPane().add(contents);
        f.pack();
        f.show();
    }
}

