/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.triad;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.apps.triad.TriadDisplay;
import edu.berkeley.guir.lib.gesture.util.HystericResizer;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TriadFrame
extends JFrame {
    boolean experimentMode = true;
    final String experimentSaveDir = "data" + File.pathSeparator + "experiment";
    final String version = "gdt 1.0";
    boolean autoSaveOn = true;
    final int SAVED = 2;
    final int AUTOSAVED = 1;
    final int NOT_SAVED = 0;
    int saveLevel = 2;
    TypedFile gestureSetFile = null;
    JLabel statusWindow;
    String lastDirectory = null;
    GestureSet gestureSet;
    TriadDisplay triadDisplay;
    Vector combinations;
    int[][] distances;
    boolean testMode = false;
    int currentCombinationIndex = -1;
    JMenuItem stopMenuItem;
    long testTime;
    Choice[] choices;
    transient Thread messageThread = null;

    public TriadFrame() {
        this("");
    }

    public TriadFrame(String name) {
        super(name);
        this.initFrame();
    }

    protected void initFrame() {
        JPanel contents = new JPanel(new BorderLayout());
        this.triadDisplay = new TriadDisplay();
        this.triadDisplay.addItemListener(new mySelector());
        contents.add((Component)this.triadDisplay, "Center");
        contents.add((Component)new JLabel("Which one is most different?"), "North");
        this.statusWindow = new JLabel();
        contents.add((Component)this.statusWindow, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)contents, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem menuItem = new JMenuItem("Open");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String directory = TriadFrame.this.lastDirectory != null ? TriadFrame.this.lastDirectory : "data";
                JFileChooser fileChooser = new JFileChooser(directory);
                int returnVal = fileChooser.showOpenDialog(TriadFrame.this.statusWindow.getTopLevelAncestor());
                switch (returnVal) {
                    case 0: {
                        TriadFrame.this.openFile(fileChooser.getSelectedFile());
                        break;
                    }
                    case 1: {
                        TriadFrame.this.message("Open cancelled", 10);
                        break;
                    }
                    default: {
                        System.err.println("Bogosity from JFileChooser");
                    }
                }
            }
        };
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Quit");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Test");
        menuItem = new JMenuItem("Start Test");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriadFrame.this.startTest();
            }
        };
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Stop Test");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriadFrame.this.stopTest();
            }
        };
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.setEnabled(false);
        this.stopMenuItem = menuItem;
        menuBar.add(menu);
        menu = new JMenu("Debug");
        menuItem = new JMenuItem("Timings");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Gesture[] gestures = TriadFrame.this.triadDisplay.getGestures();
                int i = 0;
                while (i < 3) {
                    System.out.println("Gesture " + i + ":");
                    gestures[i].printTiming(System.out);
                    ++i;
                }
            }
        };
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuBar.add(menu);
        this.getRootPane().setJMenuBar(menuBar);
        HystericResizer hr = new HystericResizer();
        this.getRootPane().addComponentListener(hr);
    }

    File autoSaveFile(File f) {
        return new File(f.getParent(), "#" + f.getName() + "#");
    }

    public void openFile(File f) {
        block14: {
            this.lastDirectory = f.getParent();
            File asFile = this.autoSaveFile(f);
            boolean usingAutosave = false;
            try {
                if (asFile.exists() && asFile.lastModified() > f.lastModified()) {
                    int useAutosave = JOptionPane.showConfirmDialog(this, "Autosave file exists for '" + f.getName() + "'.  Use autosave file?", "gdt: Use Autosave File?", 1, 3);
                    switch (useAutosave) {
                        case 0: {
                            f = asFile;
                            this.openActualFile(f);
                            break block14;
                        }
                        case 1: {
                            this.message("Autosave disabled until file saved");
                            this.autoSaveOn = false;
                            this.openActualFile(f);
                            break block14;
                        }
                        case 2: {
                            return;
                        }
                        default: {
                            this.message("WARNING: bogosity in TriadFrame.openFile");
                            return;
                        }
                    }
                }
                this.openActualFile(f);
            }
            catch (ClassNotFoundException e) {
                this.message("Cannot find required class while reading file '" + f + "': " + e);
            }
            catch (InvalidClassException e) {
                this.message("Problem with a class while reading file '" + f + "': " + e);
            }
            catch (StreamCorruptedException e) {
                this.message("The stream for file '" + f + "' is corrupted");
            }
            catch (ObjectStreamException e) {
                this.message("Expected an object but got primitive data while reading file '" + f + "': " + e);
            }
            catch (IOException e) {
                this.message("I/O error reading file '" + f + "': " + e);
            }
            catch (ParseException e) {
                this.message("Error parsing file '" + f + "': " + e);
            }
            catch (UnknownClassException e) {
                this.message("Error reading file '" + f + "': " + e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TypedFile openActualFile(File f) throws IOException, ParseException, UnknownClassException, ClassNotFoundException {
        Object var7_12;
        boolean OK = false;
        boolean NON_BINARY = true;
        int ERROR = 2;
        TypedFile openedFile = null;
        try {
            ObjectInputStream p;
            block14: {
                TypedFile typedFile;
                p = new ObjectInputStream(new FileInputStream(f));
                try {
                    Object obj;
                    String v = (String)p.readObject();
                    if (!"gdt 1.0".equals(v)) {
                        this.message("Error while reading file '" + f + "': expected version '" + "gdt 1.0" + "' but got version '" + v + "'");
                    }
                    if ((obj = p.readObject()) instanceof GestureSet) {
                        this.setGestureSet((GestureSet)obj);
                        break block14;
                    }
                    if (!(obj instanceof GestureCategory)) throw new UnknownClassException("Unknown object type '" + obj.getClass().getName() + "'");
                    this.message("Cannot use GestureCategory files.  Need a GestureSet file..");
                    typedFile = null;
                    Object var9_16 = null;
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    p.close();
                    throw throwable;
                }
                p.close();
                return typedFile;
            }
            Object var9_18 = null;
            p.close();
            this.stopTest();
            openedFile = new TypedFile(f, "binary");
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Cannot find required class while reading file '" + f + "': " + e);
        }
        catch (InvalidClassException e) {
            throw new InvalidClassException("Problem with a class while reading file '" + f + "': " + e);
        }
        catch (StreamCorruptedException e) {
        }
        catch (ObjectStreamException e) {
            throw new IOException("Expected an object but got primitive data while reading file '" + f + "': " + e);
        }
        catch (IOException e) {
            throw new IOException("I/O error reading file '" + f + "': " + e);
        }
        if (openedFile != null) return openedFile;
        FileReader reader = new FileReader(f);
        try {
            this.setGestureSet(GestureSet.read(reader));
            openedFile = new TypedFile(f, "ASCII");
        }
        catch (Throwable throwable) {
            var7_12 = null;
            reader.close();
            throw throwable;
        }
        {
            var7_12 = null;
        }
        reader.close();
        return openedFile;
    }

    private void setGestureSet(GestureSet gs) {
        this.gestureSet = gs;
        this.computeCombinations();
        Misc.shuffle(this.combinations);
        this.testDisplay();
    }

    public void message(String msg) {
        this.message(msg, 300000);
    }

    public void message(String msg, int delay) {
        final int delaytime = delay;
        if (this.messageThread != null) {
            this.messageThread.stop();
        }
        this.statusWindow.setText(msg);
        this.statusWindow.paintImmediately(this.getBounds());
        if (delaytime > 0) {
            this.messageThread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(delaytime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TriadFrame.this.statusWindow.setText("");
                }
            };
            this.messageThread.setDaemon(true);
            this.messageThread.setName("message thread");
            this.messageThread.start();
        }
    }

    void testDisplay() {
        Gesture[] gestures = new Gesture[3];
        int i = 0;
        while (i < 3) {
            GestureCategory gc = (GestureCategory)this.gestureSet.getCategories().get(i);
            gestures[i] = gc.gestureAt(0);
            ++i;
        }
        this.triadDisplay.setGestures(gestures);
    }

    void computeCombinations() {
        this.combinations = new Vector();
        int numCategories = this.gestureSet.size();
        int i = 0;
        while (i < numCategories) {
            int j = i + 1;
            while (j < numCategories) {
                int k = j + 1;
                while (k < numCategories) {
                    int[] triad2 = new int[]{i, j, k++};
                    this.combinations.addElement(triad2);
                }
                ++j;
            }
            ++i;
        }
        System.err.println(String.valueOf(this.combinations.size()) + " combinations");
        this.choices = new Choice[this.combinations.size()];
    }

    void startTest() {
        this.testTime = System.currentTimeMillis();
        int numCategories = this.gestureSet.size();
        this.distances = new int[numCategories][numCategories];
        this.testMode = true;
        this.stopMenuItem.setEnabled(true);
        this.currentCombinationIndex = -1;
        this.nextTriad();
    }

    void nextTriad() {
        ++this.currentCombinationIndex;
        int numCombinations = this.combinations.size();
        if (this.currentCombinationIndex < numCombinations) {
            this.message(String.valueOf(this.currentCombinationIndex + 1) + " of " + numCombinations);
            int[] currentCombination = (int[])this.combinations.elementAt(this.currentCombinationIndex);
            Gesture[] gestures = new Gesture[3];
            int i = 0;
            while (i < 3) {
                gestures[i] = ((GestureCategory)this.gestureSet.getCategories().get(currentCombination[i])).gestureAt(0);
                ++i;
            }
            this.triadDisplay.setGestures(gestures, true);
        } else {
            this.stopTest();
        }
    }

    void stopTest() {
        long duration = (System.currentTimeMillis() - this.testTime) / 1000L;
        System.out.println("test time: " + duration / 60L + " minutes, " + duration % 60L + " seconds");
        this.testMode = false;
        JOptionPane.showMessageDialog(this, new String("That's the end.  Thanks."), "Test finished", 1, null);
        this.saveResults();
        this.stopMenuItem.setEnabled(false);
    }

    TypedFile askForSaveFile() {
        String directory = this.lastDirectory != null ? this.lastDirectory : (this.experimentMode ? this.experimentSaveDir : "data");
        JFileChooser fileChooser = new JFileChooser(directory);
        JPanel panel = new JPanel();
        panel.add(new JLabel("File type"));
        JComboBox<String> fileType = new JComboBox<String>();
        fileType.addItem("ASCII");
        fileType.addItem("Binary");
        panel.add(fileType);
        panel.setMaximumSize(panel.getPreferredSize());
        fileChooser.setAccessory(panel);
        int returnVal = fileChooser.showSaveDialog(this.statusWindow.getTopLevelAncestor());
        switch (returnVal) {
            case 0: {
                return new TypedFile(fileChooser.getSelectedFile(), (String)fileType.getSelectedItem());
            }
            case 1: {
                this.message("Save cancelled", 10);
                break;
            }
            default: {
                System.err.println("Bogosity from JFileChooser");
            }
        }
        return null;
    }

    void saveResults() {
        TypedFile saveFile = this.askForSaveFile();
        if (saveFile != null) {
            try {
                System.err.println("Saving...");
                FileWriter writer = new FileWriter(saveFile.getPath(), true);
                int numCategories = this.gestureSet.size();
                DecimalFormat format = new DecimalFormat(" ########");
                int i = 0;
                while (i < numCategories) {
                    int j = 0;
                    while (j < numCategories) {
                        if (j > 0) {
                            writer.write("\t");
                        }
                        writer.write(Integer.toString(this.distances[i][j]));
                        ++j;
                    }
                    writer.write("\n");
                    ++i;
                }
                writer.close();
                String logFileName = String.valueOf(saveFile.getPath()) + "-log";
                writer = new FileWriter(logFileName);
                int i2 = 0;
                while (i2 < this.choices.length && this.choices[i2] != null) {
                    writer.write(String.valueOf(this.choices[i2].selection) + "\t" + this.choices[i2].time + "\t" + this.choices[i2].gestureNames[0] + "\t" + this.choices[i2].gestureNames[1] + "\t" + this.choices[i2].gestureNames[2] + "\n");
                    ++i2;
                }
                writer.close();
                System.err.println("Saved");
            }
            catch (IOException e) {
                this.message("I/O error while writing file '" + saveFile.getPath() + "': " + e);
            }
        }
    }

    class myFilenameFilter
    implements FilenameFilter {
        myFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".gs");
        }
    }

    class mySelector
    implements ItemListener {
        final long minDelay = 500L;
        long lastItemTime = 0L;

        mySelector() {
        }

        public void itemStateChanged(ItemEvent e) {
            TriadFrame triadFrame = TriadFrame.this;
            if (triadFrame.testMode) {
                long currentTime = System.currentTimeMillis();
                long deltaT = currentTime - this.lastItemTime;
                if (deltaT > 500L) {
                    this.lastItemTime = currentTime;
                    int[] currentCombination = (int[])TriadFrame.this.combinations.elementAt(TriadFrame.this.currentCombinationIndex);
                    currentCombination = (int[])currentCombination.clone();
                    int selectionIndex = (Integer)e.getItem();
                    TriadFrame.this.choices[TriadFrame.this.currentCombinationIndex] = new Choice(deltaT, ((GestureCategory)TriadFrame.this.gestureSet.getCategories().get(currentCombination[0])).getName(), ((GestureCategory)TriadFrame.this.gestureSet.getCategories().get(currentCombination[1])).getName(), ((GestureCategory)TriadFrame.this.gestureSet.getCategories().get(currentCombination[2])).getName(), selectionIndex);
                    if (selectionIndex != 0) {
                        int temp = currentCombination[selectionIndex];
                        currentCombination[selectionIndex] = currentCombination[0];
                        currentCombination[0] = temp;
                    }
                    int[] nArray = triadFrame.distances[currentCombination[0]];
                    int n = currentCombination[1];
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = triadFrame.distances[currentCombination[1]];
                    int n2 = currentCombination[0];
                    nArray2[n2] = nArray2[n2] + 1;
                    int[] nArray3 = triadFrame.distances[currentCombination[0]];
                    int n3 = currentCombination[2];
                    nArray3[n3] = nArray3[n3] + 1;
                    int[] nArray4 = triadFrame.distances[currentCombination[2]];
                    int n4 = currentCombination[0];
                    nArray4[n4] = nArray4[n4] + 1;
                    triadFrame.nextTriad();
                }
            } else {
                triadFrame.message("Start test");
            }
        }
    }

    class Choice
    implements Externalizable {
        public int selection;
        public long time;
        public String[] gestureNames;

        public Choice() {
        }

        public Choice(long time, String name1, String name2, String name3, int selection) {
            this.time = time;
            this.selection = selection;
            this.gestureNames = new String[3];
            this.gestureNames[0] = name1;
            this.gestureNames[1] = name2;
            this.gestureNames[2] = name3;
        }

        public Choice(long time, String[] names, int selection) {
            this(time, names[0], names[1], names[2], selection);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.selection);
            out.writeChars(" ");
            out.writeLong(this.time);
            out.writeChars(" ");
            out.writeObject(this.gestureNames);
            out.writeChars("\n");
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    public class TypedFile
    extends File {
        String type;

        TypedFile(File f, String type) {
            super(f.getAbsolutePath());
            this.setType(type);
        }

        void setType(String t) {
            this.type = t.intern();
        }

        String getType() {
            return this.type;
        }
    }

    public class UnknownClassException
    extends Exception {
        public UnknownClassException() {
        }

        public UnknownClassException(String detail) {
            super(detail);
        }
    }
}

