/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.triad;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureDisplay;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;

public class TriadDisplay
extends JPanel
implements ItemSelectable {
    protected EventListenerList itemListenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    public TriadDisplay() {
        super(true);
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new FlowLayout(1, 20, 20));
        Border border = BorderFactory.createLoweredBevelBorder();
        int i = 0;
        while (i < 3) {
            GestureDisplay gestureDisplay = new GestureDisplay();
            JPanel dummy = new JPanel(new BorderLayout());
            dummy.add((Component)gestureDisplay, "Center");
            this.add(dummy);
            gestureDisplay.addMouseListener(new myListener(i));
            gestureDisplay.setBorder(border);
            gestureDisplay.setOffset(5, 5);
            ++i;
        }
    }

    protected GestureDisplay getGestureDisplay(int i) {
        return (GestureDisplay)((Container)this.getComponent(i)).getComponent(0);
    }

    public void setGestures(Gesture g1, Gesture g2, Gesture g3) {
        Gesture[] g = new Gesture[]{g1, g2, g3};
        this.setGestures(g);
    }

    public void setGestures(Gesture[] gestures) {
        this.setGestures(gestures, false);
    }

    public void setGestures(Gesture[] g, boolean randomize) {
        Object[] gestures = new NumberedGesture[g.length];
        int i = 0;
        while (i < 3) {
            gestures[i] = new NumberedGesture(g[i], i);
            ++i;
        }
        if (randomize) {
            Misc.shuffle(gestures);
        }
        i = 0;
        while (i < 3) {
            GestureDisplay gestureDisplay = this.getGestureDisplay(i);
            gestureDisplay.setGesture((Gesture)gestures[i]);
            gestureDisplay.getGesturePointsDisplay().setAnimated(true);
            ++i;
        }
        this.invalidate();
        Window w = (Window)this.getTopLevelAncestor();
        if (w != null) {
            w.pack();
        }
    }

    public Gesture[] getGestures() {
        Component[] components = this.getComponents();
        Gesture[] result = new Gesture[3];
        int i = 0;
        while (i < 3) {
            GestureDisplay gestureDisplay = this.getGestureDisplay(i);
            result[i] = gestureDisplay.getGesture();
            ++i;
        }
        return result;
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.remove(clazz, l);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    protected void fireItemChange(int gestureNum) {
        ItemEvent event = null;
        Object[] listeners = this.itemListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ItemEvent(this, 701, new Integer(gestureNum), 1);
                }
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    class myListener
    extends MouseAdapter {
        int componentNum;

        public myListener(int n) {
            this.componentNum = n;
        }

        void invert() {
            GestureDisplay component = TriadDisplay.this.getGestureDisplay(this.componentNum);
            Color fg = component.getForeground();
            Color bg = component.getBackground();
            ((Component)component).setForeground(bg);
            ((Component)component).setBackground(fg);
        }

        public void mousePressed(MouseEvent e) {
            this.invert();
        }

        public void mouseReleased(MouseEvent e) {
            this.invert();
            GestureDisplay gd = TriadDisplay.this.getGestureDisplay(this.componentNum);
            NumberedGesture gesture = (NumberedGesture)gd.getGesture();
            TriadDisplay.this.fireItemChange(gesture.n);
        }
    }

    class NumberedGesture
    extends Gesture {
        final int n;

        NumberedGesture(Gesture g, int n) {
            super(g);
            this.n = n;
        }
    }
}

