/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureFile;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.WindowManager;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import javax.swing.UIManager;

public class gdt
implements GDTConstants {
    static {
        Properties.setPropertyPersistence("correctly recognized", false);
    }

    private gdt() {
    }

    public static void main(String[] argv) {
        boolean experiment = false;
        boolean useDefaults = false;
        boolean showWarnings = true;
        int i = 0;
        while (i < argv.length && argv[i].charAt(0) == '-') {
            if (argv[i].equals("-e")) {
                experiment = true;
            } else if (argv[i].equals("-defaults")) {
                useDefaults = true;
            } else if (argv[i].equals("-no-warnings")) {
                showWarnings = false;
            } else {
                System.err.println("gdt: Unknown option: " + argv[i]);
                System.err.println("gdt: usage: gdt [-e] [-defaults] [gesturefile1 [gesturefile2 ...]]");
            }
            ++i;
        }
        if (!useDefaults) {
            gdt.setDefaults();
        }
        MainFrame.setDebugMenu(!experiment);
        MainFrame.setWarningsEnabled(showWarnings);
        if (i < argv.length) {
            while (i < argv.length) {
                GestureFile file = new GestureFile(new File(argv[i]));
                MainFrame frame = WindowManager.createMainFrame(file);
                frame.pack();
                frame.show();
                ++i;
            }
        } else {
            MainFrame frame = WindowManager.createMainFrame();
            frame.pack();
            frame.show();
        }
    }

    static void setDefaults() {
        Font bigFont = new Font("Serif", 0, 16);
        Font smallFont = new Font("Serif", 0, 14);
        UIManager.put("Label.font", bigFont);
        UIManager.put("Label.background", Color.lightGray);
        UIManager.put("Label.foreground", Color.black);
        UIManager.put("TitledBorder.font", smallFont);
        UIManager.put("TitledBorder.foreground", Color.black);
        UIManager.put("TitledBorder.titleColor", Color.black);
        UIManager.put("CheckBoxMenuItem.font", bigFont);
        UIManager.put("MenuItem.font", bigFont);
        UIManager.put("Menu.font", bigFont);
        UIManager.put("Button.font", bigFont);
        UIManager.put("ToggleButton.font", bigFont);
        UIManager.put("TextPane.font", bigFont);
        UIManager.put("TextField.font", bigFont);
        UIManager.put("Tree.font", bigFont);
    }
}

