/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import edu.berkeley.guir.lib.gesture.apps.gdt.NoticeHandler;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskManager {
    private static final long DELAY_AFTER_CHANGE = 10000L;
    private static Map taskManagers = new HashMap();
    private MainFrame mainFrame;
    private List taskList = Collections.synchronizedList(new ArrayList());
    private PropertyChangeListener propChangeListener = new MyPropChangeListener();
    private int currentTask = -1;
    private ManagerThread managerThread = null;

    private TaskManager(MainFrame mf) {
        this.mainFrame = mf;
        this.mainFrame.getGesturePackage().addPropertyChangeListener(this.propChangeListener);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (TaskManager.this.managerThread != null) {
                    TaskManager.this.managerThread.halt();
                }
            }
        });
    }

    public static TaskManager getTaskManager(MainFrame mainFrame) {
        TaskManager newManager;
        if (taskManagers.containsKey(mainFrame)) {
            newManager = (TaskManager)taskManagers.get(mainFrame);
        } else {
            newManager = new TaskManager(mainFrame);
            taskManagers.put(mainFrame, newManager);
        }
        return newManager;
    }

    public void addTask(NoticeTask task) {
        this.taskList.add(task);
        if (this.taskCount() == 1 && this.managerThread != null) {
            ManagerThread managerThread = this.managerThread;
            synchronized (managerThread) {
                this.managerThread.notify();
            }
        }
    }

    public void removeAllTasks() {
        this.taskList.clear();
        if (this.managerThread != null) {
            this.managerThread.halt();
            ManagerThread managerThread = this.managerThread;
            synchronized (managerThread) {
                this.managerThread = null;
            }
        }
    }

    public void start() {
        if (this.managerThread == null) {
            this.managerThread = new ManagerThread();
            System.out.println("TM: starting manager thread");
            this.managerThread.start();
        } else {
            System.out.println("Warning: starting when manager thread already exists");
        }
    }

    public NoticeTask getTask(int i) {
        return (NoticeTask)this.taskList.get(i);
    }

    public int taskCount() {
        return this.taskList.size();
    }

    private NoticeTask getNextTask() {
        NoticeTask result;
        List list = this.taskList;
        synchronized (list) {
            int count = this.taskCount();
            if (count == 0) {
                result = null;
            } else if (this.currentTask >= count - 1) {
                this.currentTask = -1;
                result = null;
            } else {
                ++this.currentTask;
                result = this.getTask(this.currentTask);
            }
        }
        return result;
    }

    private void resetTaskIteration() {
        this.currentTask = -1;
    }

    public static void checkForInterrupt() throws InterruptedException {
        TaskManager.checkForInterrupt(null);
    }

    public static void checkForInterrupt(String details) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(details);
        }
    }

    public interface NoticeTask {
        public Set computeNotices() throws InterruptedException;
    }

    private class MyPropChangeListener
    implements PropertyChangeListener {
        MyPropChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            PropertyChangeEvent rootEvent;
            String name;
            if (TaskManager.this.managerThread != null && Misc.indexOf(GDTConstants.CHANGE_PROPERTIES, name = (rootEvent = Properties.getRootEvent(e)).getPropertyName()) != -1) {
                TaskManager.this.managerThread.changeNotify();
            }
        }
    }

    private class ManagerThread
    extends Thread {
        private boolean packageChanged;
        private Boolean shouldStop = new Boolean(false);

        public ManagerThread() {
            this.setDaemon(true);
            this.setPriority(Math.max(Thread.currentThread().getPriority() - 2, 1));
            this.setName("ManagerThread for " + TaskManager.this.mainFrame.getGesturePackage());
        }

        public void changeNotify() {
            this.packageChanged = true;
            this.interrupt();
        }

        private boolean isStopTime() {
            Boolean bl = this.shouldStop;
            synchronized (bl) {
                return this.shouldStop;
            }
        }

        public void run() {
            this.packageChanged = true;
            while (!this.isStopTime()) {
                if (this.packageChanged) {
                    TaskManager.this.resetTaskIteration();
                    this.packageChanged = false;
                    int i = 0;
                    boolean caughtChange = false;
                    Set oldNotices = NoticeHandler.getNotices(TaskManager.this.mainFrame.getGesturePackage());
                    HashSet currentNotices = new HashSet(oldNotices.size());
                    NoticeTask task = TaskManager.this.getNextTask();
                    while (task != null && !Thread.interrupted() && !this.isStopTime()) {
                        System.out.println("TM: start #" + i);
                        try {
                            currentNotices.addAll(task.computeNotices());
                        }
                        catch (InterruptedException e) {
                            caughtChange = true;
                            this.interrupt();
                        }
                        catch (Exception e) {
                            System.err.println("Warning: task " + task + " threw an unexpected exception:");
                            e.printStackTrace();
                        }
                        System.out.println("TM: done  #" + i);
                        task = TaskManager.this.getNextTask();
                        ++i;
                    }
                    if (task == null) {
                        Notice notice;
                        System.out.println("updating notices");
                        HashSet newNotices = new HashSet(currentNotices);
                        newNotices.removeAll(oldNotices);
                        NoticeHandler.addNotices(newNotices);
                        HashSet staleNotices = new HashSet(oldNotices);
                        staleNotices.removeAll(currentNotices);
                        Iterator iter = staleNotices.iterator();
                        while (iter.hasNext()) {
                            notice = (Notice)iter.next();
                            NoticeHandler.removeNotice(notice);
                        }
                        if (TaskManager.this.mainFrame.areNoticesVisible()) {
                            TaskManager.this.mainFrame.setLogBackground(Color.lightGray);
                            iter = newNotices.iterator();
                            while (iter.hasNext()) {
                                notice = (Notice)iter.next();
                                TaskManager.this.mainFrame.getNoticeHandler().showNotice(notice);
                            }
                            TaskManager.this.mainFrame.setLogBackground(Color.white);
                        }
                        TaskManager.this.mainFrame.updateMetrics();
                        Map noticeSummary = NoticeHandler.getNoticeSummary(TaskManager.this.mainFrame.getGesturePackage().getTrainingSet());
                        Set keySet = noticeSummary.keySet();
                        Iterator iter2 = keySet.iterator();
                        while (iter2.hasNext()) {
                            Object key = iter2.next();
                            Collection value = (Collection)noticeSummary.get(key);
                            System.out.println("\t" + key + "\t" + value.size());
                        }
                        System.out.println("notices updated");
                    }
                    if (!caughtChange) continue;
                    this.waitForNoChange();
                    continue;
                }
                try {
                    ManagerThread managerThread = this;
                    synchronized (managerThread) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.waitForNoChange();
            }
            System.out.println("TM: exit run()");
            if (TaskManager.this.managerThread == this) {
                ManagerThread managerThread = TaskManager.this.managerThread;
                synchronized (managerThread) {
                    TaskManager.this.managerThread = null;
                }
            }
        }

        private void waitForNoChange() {
            boolean finishedWaiting = false;
            while (!finishedWaiting) {
                try {
                    ManagerThread managerThread = this;
                    synchronized (managerThread) {
                        this.wait(10000L);
                    }
                    finishedWaiting = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void clearNotices() {
            this.clearNotices(TaskManager.this.mainFrame.getGesturePackage());
        }

        private void clearNotices(GestureContainer container) {
            Iterator iter = container.iterator();
            while (iter.hasNext()) {
                GestureObject obj = (GestureObject)iter.next();
                obj.unsetProperty("notice list");
                if (!(obj instanceof GestureContainer)) continue;
                this.clearNotices((GestureContainer)obj);
                obj.unsetProperty("notice descendents");
            }
        }

        public void halt() {
            Boolean bl = this.shouldStop;
            synchronized (bl) {
                this.shouldStop = new Boolean(true);
            }
            this.interrupt();
        }
    }
}

