/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.ReferenceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SummaryLog
extends JScrollPane {
    public static Icon START_ICON;
    protected static MutableAttributeSet hyperlinkAttributes;
    public static final String FONT = "SummaryLog.font";
    protected static final String TOOLTIP_ATTRIB = "TOOLTIP_ATTRIB";
    protected JTextPane textPane = new JTextPane();
    protected MainFrame mainFrame;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        START_ICON = new ImageIcon(clazz.getResource("images/circle.bm"));
        hyperlinkAttributes = new SimpleAttributeSet();
        StyleConstants.setUnderline(hyperlinkAttributes, true);
        StyleConstants.setForeground(hyperlinkAttributes, Color.blue);
    }

    public SummaryLog(MainFrame mf) {
        this.mainFrame = mf;
        this.buildUI();
    }

    protected void buildUI() {
        this.textPane.setFont(UIManager.getFont(FONT));
        this.setViewportView(this.textPane);
        this.textPane.setAutoscrolls(true);
        this.textPane.setEditable(false);
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ActionListener link;
                if (SwingUtilities.isLeftMouseButton(e) && (link = SummaryLog.this.getHyperlink(e)) != null) {
                    link.actionPerformed(new ActionEvent(SummaryLog.this.textPane, 0, null));
                }
            }
        });
        this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (SummaryLog.this.getHyperlink(e) != null && SummaryLog.this.textPane.getCursor() != Cursor.getPredefinedCursor(3)) {
                    SummaryLog.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                    String toolTip = SummaryLog.this.getToolTip(e);
                    if (toolTip != null) {
                        SummaryLog.this.textPane.setToolTipText(toolTip);
                    }
                } else {
                    SummaryLog.this.textPane.setCursor(Cursor.getPredefinedCursor(2));
                    SummaryLog.this.textPane.setToolTipText(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttributeSet getAttributes(MouseEvent e) {
        int pos = this.getPosition(e);
        StyledDocument styledDoc = (StyledDocument)this.textPane.getDocument();
        ((AbstractDocument)((Object)styledDoc)).readLock();
        AttributeSet as = null;
        try {
            as = styledDoc.getCharacterElement(pos).getAttributes();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ((AbstractDocument)((Object)styledDoc)).readUnlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            ((AbstractDocument)((Object)styledDoc)).readUnlock();
            return as;
        }
    }

    protected ActionListener getHyperlink(MouseEvent e) {
        AttributeSet as = this.getAttributes(e);
        ActionListener link = (ActionListener)as.getAttribute(SummaryConstants.Link);
        return link;
    }

    protected String getToolTip(MouseEvent e) {
        AttributeSet as = this.getAttributes(e);
        return (String)as.getAttribute(TOOLTIP_ATTRIB);
    }

    public int getPosition(MouseEvent e) {
        Point p = e.getPoint();
        int pos = this.textPane.viewToModel(p);
        return pos;
    }

    public void setTextBackground(Color c) {
        this.textPane.setBackground(c);
    }

    public void message(String msg) {
        this.append(String.valueOf(msg) + "\n");
        this.scrollToEnd();
    }

    public void scrollToEnd() {
        try {
            this.textPane.setCaretPosition(this.textPane.getDocument().getLength() - 1);
        }
        catch (Exception e) {
            System.err.println("WARNING: another error in Sun's JTextPane: " + e);
        }
    }

    protected void selectEnd() {
        int length = this.textPane.getDocument().getLength();
        try {
            this.textPane.setSelectionStart(length);
            this.textPane.setSelectionEnd(length);
        }
        catch (Exception e) {
            System.err.println("WARNING: another error in Sun's JTextPane: " + e);
        }
    }

    public void append(String msg) {
        this.append(msg, null);
    }

    public void append(String msg, AttributeSet as) {
        Document document = this.textPane.getDocument();
        try {
            document.insertString(document.getLength(), msg, as);
        }
        catch (BadLocationException e) {
            System.err.println("WARNING: weirdness in SummaryLog Document: " + e);
        }
        catch (RuntimeException e) {
            System.err.println("WARNING: another error in Sun's JTextPane: " + e);
        }
    }

    public void append(Component component) {
        this.selectEnd();
        component.setFont(this.textPane.getFont());
        try {
            this.textPane.setEditable(true);
            this.textPane.insertComponent(component);
            this.textPane.setEditable(false);
            this.textPane.validate();
        }
        catch (Exception e) {
            System.err.println("WARNING: another error in Sun's JTextPane: " + e);
        }
    }

    public void append(Icon icon) {
        this.selectEnd();
        try {
            this.textPane.setEditable(true);
            this.textPane.insertIcon(icon);
            this.textPane.setEditable(false);
        }
        catch (Exception e) {
            System.err.println("WARNING: another error in Sun's JTextPane: " + e);
        }
    }

    public void appendStartIcon() {
        this.append(START_ICON);
        this.append(" ");
    }

    public JButton appendButton(String label, ActionListener actionListener) {
        JButton button = new JButton(label);
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        button.setCursor(Cursor.getPredefinedCursor(0));
        this.append(button);
        return button;
    }

    public void appendLink(String label, ActionListener listener) {
        this.appendLink(label, listener, null);
    }

    public void appendLink(String label, ActionListener listener, String tooltip) {
        SimpleAttributeSet as = new SimpleAttributeSet(hyperlinkAttributes);
        if (tooltip != null) {
            as.addAttribute(TOOLTIP_ATTRIB, tooltip);
        }
        SummaryConstants.setLink(as, listener);
        this.append(label, as);
    }

    public void appendLink(final GestureContainer container) {
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SummaryLog.this.mainFrame.getDesktop().showFrame(container);
            }
        };
        String name = container.getName();
        this.appendLink(name, l, "Make new view for " + name);
    }

    public void appendFeatureLink(Class featureClass) {
        String featureName = FeatureFactory.getFeatureName(featureClass);
        final String featureTag = ReferenceManager.getFeatureTag(featureClass);
        this.appendLink(featureName, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReferenceManager.getManager().showReference(SummaryLog.this.mainFrame, featureTag);
            }
        }, "Find out what this feature is");
    }

    public Position createEndPosition() {
        Document doc = this.textPane.getDocument();
        Position result = null;
        try {
            result = doc.createPosition(doc.getLength() - 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public Document getDocument() {
        return this.textPane.getDocument();
    }

    public int length() {
        return this.textPane.getDocument().getLength();
    }

    public void clear() {
        this.textPane.setText("");
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public static class SummaryConstants {
        private String representation;
        public static final Object Link = new SummaryConstants("gdt summary link");

        public SummaryConstants(String rep) {
            this.representation = rep;
        }

        public static ActionListener getLink(AttributeSet a) {
            return (ActionListener)a.getAttribute(Link);
        }

        public static void setLink(MutableAttributeSet a, ActionListener listener) {
            a.addAttribute(Link, listener);
        }
    }
}

