/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePointsDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.EnableListener;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SimpleGestureObjectPanel
extends JPanel
implements GestureObjectDisplay {
    protected PropertyChangeListener propChangeListener = new MyPropChangeListener();
    protected EventListenerList listenerList = new EventListenerList();
    protected GesturePointsDisplay pointsDisplay = new GesturePointsDisplay();
    protected double scale = 1.0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SimpleGestureObjectPanel() {
        this((GestureObject)null);
    }

    public SimpleGestureObjectPanel(GestureObject object) {
        super(new BorderLayout());
        this.setDisplayedObject(object);
        this.pointsDisplay.setOffset(5, 5);
        this.add((Component)this.pointsDisplay, "Center");
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointsDisplay != null) {
            this.pointsDisplay.setBackground(bg);
        }
    }

    public void setDisplayedObject(GestureObject object) {
        this.setGesture((Gesture)object);
    }

    public void setGesture(Gesture g) {
        Gesture oldValue = this.pointsDisplay.getGesture();
        if (oldValue != g) {
            if (oldValue != null) {
                oldValue.removePropertyChangeListener(this.propChangeListener);
            }
            this.pointsDisplay.setGesture(g);
            if (g != null) {
                g.addPropertyChangeListener(this.propChangeListener);
            }
        }
    }

    public GestureObject getDisplayedObject() {
        return this.pointsDisplay.getGesture();
    }

    public String getInputGestureTitle() {
        return "Draw a replacement example gesture";
    }

    public boolean canAcceptGesture() {
        return true;
    }

    public boolean gestureDrawn(Gesture gesture) {
        Gesture currentGesture = this.pointsDisplay.getGesture();
        gesture.normalize();
        currentGesture.setPoints(gesture.getPoints());
        return true;
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public boolean isCommandValid(int id) {
        return false;
    }

    public void doCommand(int id) {
        System.err.println("SimpleGestureObjectPanel handles no commands (was given id " + id + ")");
    }

    private static String toString(GestureObject g) {
        return g.toString();
    }

    public void setScale(double s) {
        this.scale = s;
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform t = g2d.getTransform();
        g2d.scale(this.scale, this.scale);
        super.paint(g);
        g2d.setTransform(t);
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    protected class MyPropChangeListener
    extends EnableListener {
        public MyPropChangeListener() {
            super(SimpleGestureObjectPanel.this);
        }
    }
}

