/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import edu.berkeley.guir.lib.web.WebBrowserFrame;
import edu.berkeley.guir.lib.web.WebBrowserPanel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.SwingUtilities;

public class ReferenceManager {
    protected static final String REFERENCE_FRAME_PROP = "REFERENCE_FRAME";
    protected static ReferenceManager defaultManager = new ReferenceManager();
    protected static final String REFERENCE_MANUAL = "doc/reference.html";
    protected static final String TUTORIAL = "doc/tutorial.html";

    protected ReferenceManager() {
    }

    public static ReferenceManager getManager() {
        return defaultManager;
    }

    public void showTutorial(MainFrame mainFrame) {
        this.showReference(mainFrame, TUTORIAL, null);
    }

    public void showReferenceManual(MainFrame mainFrame) {
        this.showReference(mainFrame, (String)null);
    }

    public void showReference(MainFrame mainFrame, Notice notice) {
        this.showReference(mainFrame, REFERENCE_MANUAL, notice.getReferenceTag());
    }

    public void showReference(MainFrame mainFrame, String referenceTag) {
        this.showReference(mainFrame, REFERENCE_MANUAL, referenceTag);
    }

    public void showReference(final MainFrame mainFrame, final String fileName, final String referenceTag) {
        mainFrame.moreBusy();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReferenceManager.this.showReferenceImpl(mainFrame, fileName, referenceTag);
            }
        });
    }

    protected void showReferenceImpl(final MainFrame mainFrame, String fileName, final String refTag) {
        URL url;
        WebBrowserFrame browserFrame = (WebBrowserFrame)mainFrame.getRootPane().getClientProperty(REFERENCE_FRAME_PROP);
        if (browserFrame == null) {
            browserFrame = new WebBrowserFrame();
            browserFrame.setSize(new Dimension(800, 800));
            browserFrame.setTitle(String.valueOf(mainFrame.getGesturePackage().getName()) + " - " + "Reference - quill");
            mainFrame.getRootPane().putClientProperty(REFERENCE_FRAME_PROP, browserFrame);
        }
        if ((url = this.getClass().getClassLoader().getResource(fileName)) == null) {
            mainFrame.message("ERROR: Can't find reference manual (at '" + fileName + "').\n");
            mainFrame.lessBusy();
            return;
        }
        final WebBrowserFrame finalBrowserFrame = browserFrame;
        final WebBrowserPanel finalBrowserPanel = browserFrame.getWebBrowserPanel();
        PropertyChangeListener l = new PropertyChangeListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    finalBrowserPanel.removePropertyChangeListener("NEW_PAGE_LOADED_EVENT", this);
                    finalBrowserFrame.setVisible(true);
                    finalBrowserFrame.toFront();
                    if (refTag != null) {
                        finalBrowserPanel.scrollToReference(refTag);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    mainFrame.lessBusy();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                    mainFrame.lessBusy();
                    return;
                }
            }
        };
        finalBrowserPanel.addPropertyChangeListener("NEW_PAGE_LOADED_EVENT", l);
        String oldUrl = finalBrowserPanel.getCurrentUrl();
        finalBrowserPanel.goToUrl(url);
        String newUrl = finalBrowserPanel.getCurrentUrl();
        if (newUrl.equals(oldUrl)) {
            l.propertyChange(null);
        }
    }

    public static String getFeatureTag(Class featureClass) {
        String wholeName = featureClass.getName();
        int lastDot = wholeName.lastIndexOf(46);
        return wholeName.substring(lastDot + 1);
    }
}

