/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.OutlierNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.RecognizerSimilarityNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.ShadowGestureSet;
import edu.berkeley.guir.lib.gesture.apps.gdt.TaskManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RecognizerSimilarityTester
implements TaskManager.NoticeTask {
    private static final double DISTANCE_THRESHOLD = 8.0;
    private static final double DISTANCE_SQ_THRESHOLD = 64.0;
    private MainFrame mainFrame;

    public RecognizerSimilarityTester(MainFrame mf) {
        this.mainFrame = mf;
    }

    public Set computeNotices() throws InterruptedException {
        GestureSet trainingSet;
        HashSet<DefaultNotice> result = new HashSet<DefaultNotice>();
        Classifier classifier = this.mainFrame.getClassifier();
        GesturePackage pkg = this.mainFrame.getGesturePackage();
        if (classifier != null && pkg != null && (trainingSet = pkg.getTrainingSet()) != null) {
            try {
                classifier.train();
            }
            catch (TrainingException e) {
                return result;
            }
            List trainingCategories = classifier.getTrainingCategories();
            int numCats = trainingCategories.size();
            int i = 0;
            while (i < numCats) {
                GestureCategory catA = null;
                int j = 0;
                while (j < i) {
                    double dist = classifier.categoryDistance(i, j);
                    if (dist <= 64.0) {
                        if (catA == null) {
                            catA = (GestureCategory)trainingCategories.get(i);
                        }
                        GestureCategory catB = (GestureCategory)trainingCategories.get(j);
                        List outliers = this.findOutlierCategories(trainingCategories, i, j, dist);
                        if (outliers.size() > 0) {
                            result.add(new OutlierNotice(this.mainFrame, outliers, catA, catB));
                        } else {
                            Classifier.FeatureDirection fd = classifier.findPrincipleFeature(i, j);
                            result.add(new RecognizerSimilarityNotice(this.mainFrame, catA, catB, fd.featureClass, fd.direction));
                        }
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findOutlierCategories(List originalCategories, int indexA, int indexB, double oldDistance) throws InterruptedException {
        ArrayList<GestureCategory> result = new ArrayList<GestureCategory>();
        ShadowGestureSet trainingSet = new ShadowGestureSet(originalCategories);
        int numCategories = originalCategories.size();
        GestureCategory catA = (GestureCategory)originalCategories.get(indexA);
        GestureCategory catB = (GestureCategory)originalCategories.get(indexB);
        int i = 0;
        while (true) {
            block10: {
                if (i >= numCategories) {
                    return result;
                }
                if (i != indexA && i != indexB) {
                    Object var16_15;
                    GestureCategory possibleOutlier = (GestureCategory)originalCategories.get(i);
                    ((AbstractGestureContainer)trainingSet).remove(possibleOutlier);
                    try {
                        Classifier classifier = new Classifier(trainingSet);
                        try {
                            classifier.train();
                        }
                        catch (TrainingException e) {
                            var16_15 = null;
                            ((AbstractGestureContainer)trainingSet).add(possibleOutlier);
                            break block10;
                        }
                        double newDistance = classifier.categoryDistance(catA, catB);
                        if (newDistance > 64.0 && newDistance > 2.0 * oldDistance) {
                            result.add(possibleOutlier);
                        }
                    }
                    catch (Throwable throwable) {
                        var16_15 = null;
                        ((AbstractGestureContainer)trainingSet).add(possibleOutlier);
                        throw throwable;
                    }
                    {
                        var16_15 = null;
                    }
                    ((AbstractGestureContainer)trainingSet).add(possibleOutlier);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                }
            }
            ++i;
        }
    }
}

