/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.HowToPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;

public class RecognizerSimilarityNotice
extends DefaultNotice {
    private MainFrame mainFrame;
    private GestureCategory categoryA;
    private GestureCategory categoryB;
    private Class featureClass;
    private int direction;
    protected HowToPanel howToPanel = null;

    public RecognizerSimilarityNotice(MainFrame mf, GestureCategory catA, GestureCategory catB, Class featureClass, int direction) {
        this.mainFrame = mf;
        this.categoryA = catA;
        this.categoryB = catB;
        this.featureClass = featureClass;
        this.direction = direction;
    }

    public boolean hasExpired() {
        return false;
    }

    protected void displayImpl(SummaryLog log) {
        if (!this.hasExpired()) {
            log.append("Two of your gesture categories, ");
            log.appendLink(this.categoryA);
            log.append(" and ");
            log.appendLink(this.categoryB);
            log.append(", are very similar to the recognizer and may often be misrecognized. You should change one or both of them to make them less similar.");
        }
    }

    protected void displaySummaryImpl(SummaryLog log) {
        log.appendLink(this.categoryA);
        log.append(" and ");
        log.appendLink(this.categoryB);
    }

    public String getName() {
        return "Similar categories (recognizer)";
    }

    public List getObjectList() {
        GestureContainer[] dummy = new GestureContainer[]{this.categoryA, this.categoryB};
        return Arrays.asList(dummy);
    }

    public String getReferenceTag() {
        return "Too Similar for Recognizer";
    }

    public HowToPanel getHowToPanel() {
        if (this.howToPanel == null) {
            String directionB;
            String directionA;
            SummaryLog log = new SummaryLog(this.mainFrame);
            log.append("To make the gesture categories ");
            log.appendLink(this.categoryA);
            log.append(" and ");
            log.appendLink(this.categoryB);
            log.append(" easier to recognize, change the ");
            log.appendFeatureLink(this.featureClass);
            log.append(".");
            if (this.direction == 1) {
                directionA = "higher";
                directionB = "lower";
            } else {
                directionA = "lower";
                directionB = "higher";
            }
            log.append(" Make this feature " + directionA + " for ");
            log.appendLink(this.categoryA);
            log.append(" and/or " + directionB + " for ");
            log.appendLink(this.categoryB);
            log.append(".");
            this.howToPanel = new HowToPanel(this.mainFrame);
            this.howToPanel.add((Component)log, "Center");
        }
        return this.howToPanel;
    }
}

