/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.FeatureNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.GInternalFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureContainerPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureDesktop;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.ShadowGestureContainer;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class OutlyingGestureNotice
extends DefaultNotice {
    protected static Icon INFO_ICON;
    private List outlyingGestures;
    private MainFrame mainFrame;
    private GestureActionListener gestureActionListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.GestureTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INFO_ICON = new ImageIcon(clazz.getResource("images/graphics-repository/toolbarButtonGraphics/general/Information24.gif"));
    }

    public OutlyingGestureNotice(MainFrame mf, List outlyingGestures) {
        this.mainFrame = mf;
        this.outlyingGestures = outlyingGestures;
        this.gestureActionListener = new GestureActionListener();
    }

    public boolean hasExpired() {
        return this.outlyingGestures.size() == 0;
    }

    protected void displayImpl(SummaryLog log) {
        if (!this.hasExpired()) {
            log.append("There are " + this.outlyingGestures.size() + " ");
            log.appendLink("training gestures", this.gestureActionListener, "Make a new view of the training gestures");
            log.append(" that are very different from others for their gesture category. This may indicate mistakes in entering training gestures.");
        }
    }

    protected void displaySummaryImpl(SummaryLog log) {
        log.appendLink(String.valueOf(this.outlyingGestures.size()) + " training gestures", this.gestureActionListener, "Make a new view of the training gestures");
    }

    public String getName() {
        return "Outlying gestures";
    }

    public List getObjectList() {
        return this.outlyingGestures;
    }

    public String getReferenceTag() {
        return "Outlying Gesture";
    }

    protected class GestureActionListener
    implements ActionListener {
        protected GestureActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ShadowGestureContainer container = new ShadowGestureContainer(OutlyingGestureNotice.this.outlyingGestures);
            container.setName("Outlying gestures");
            JScrollPane scrollPane = new JScrollPane();
            OutlyingGestureContainerPanel panel = new OutlyingGestureContainerPanel(scrollPane);
            panel.setShadowGestureContainer(container);
            GInternalFrame iFrame = GInternalFrame.makeInternalFrame(container, panel, scrollPane);
            OutlyingGestureNotice.this.mainFrame.getDesktop().showFrame(iFrame);
        }
    }

    protected class OutlyingGestureContainerPanel
    extends GestureContainerPanel {
        protected final Border BORDER;
        protected ShadowGestureContainer shadowContainer;
        static /* synthetic */ Class class$0;

        public OutlyingGestureContainerPanel(JScrollPane scroller) {
            super(scroller);
            this.BORDER = BorderFactory.createEtchedBorder();
        }

        public void setShadowGestureContainer(ShadowGestureContainer container) {
            this.shadowContainer = container;
            super.setGestureContainer(container);
        }

        protected void addGestureObject(GestureObject gestureObj, JScrollPane scrollPane, int index) {
            Gesture gesture = (Gesture)gestureObj;
            GestureObjectPanel gesturePanel = (GestureObjectPanel)DisplayFactory.create(gestureObj, scrollPane);
            JButton okButton = new JButton("Gesture OK");
            okButton.addActionListener(new ActionListener(this, gesture){
                final /* synthetic */ OutlyingGestureContainerPanel this$1;
                private final /* synthetic */ Gesture val$gesture;
                {
                    this.this$1 = outlyingGestureContainerPanel;
                    this.val$gesture = gesture;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.shadowContainer.remove(this.val$gesture, false);
                }
            });
            JButton button = new JButton("Show " + gesture.getParent().getName());
            button.setForeground(Color.green.darker().darker());
            button.addActionListener(new ActionListener(this, gesture){
                final /* synthetic */ OutlyingGestureContainerPanel this$1;
                private final /* synthetic */ Gesture val$gesture;
                {
                    this.this$1 = outlyingGestureContainerPanel;
                    this.val$gesture = gesture;
                }

                public void actionPerformed(ActionEvent e) {
                    Class<?> clazz = OutlyingGestureContainerPanel.class$0;
                    if (clazz == null) {
                        try {
                            clazz = OutlyingGestureContainerPanel.class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.GestureDesktop");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    GestureDesktop desktop = (GestureDesktop)SwingUtilities.getAncestorOfClass(clazz, (Component)e.getSource());
                    desktop.showFrame(this.val$gesture.getParent());
                }
            });
            JButton infoButton = new JButton(INFO_ICON);
            infoButton.setMargin(new Insets(1, 1, 1, 1));
            InfoActionListener infoActionListener = new InfoActionListener(gesture);
            infoButton.addActionListener(infoActionListener);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(okButton);
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(button);
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(infoButton);
            gesturePanel.add((Component)buttonPanel, "South");
            gesturePanel.setBorder(this.BORDER);
            this.add((Component)gesturePanel, index);
        }
    }

    public class InfoActionListener
    implements ActionListener {
        protected Gesture gesture;

        public InfoActionListener(Gesture g) {
            this.gesture = g;
        }

        public void actionPerformed(ActionEvent event) {
            Classifier classifier = OutlyingGestureNotice.this.mainFrame.getClassifier();
            GestureCategory category = (GestureCategory)this.gesture.getParent();
            double[] distByFeature = classifier.getNormalizedDistancesByFeature(this.gesture, category.getName());
            int maxDistIndex = Misc.maxAbsIndex(Misc.promoteArray(distByFeature));
            Class[] featureClasses = classifier.getFeatureClasses();
            Feature dummyFeature = null;
            try {
                dummyFeature = (Feature)featureClasses[maxDistIndex].newInstance();
            }
            catch (InstantiationException e) {
                System.err.println("Warning: could not instantiate feature of class '" + featureClasses[maxDistIndex].getName() + "':" + e);
                return;
            }
            catch (IllegalAccessException e) {
                System.err.println("Warning: could not access class '" + featureClasses[maxDistIndex].getName() + "':" + e);
                return;
            }
            OutlyingGestureNotice.this.mainFrame.getNoticeHandler().showNotice(new FeatureNotice(dummyFeature, this.gesture, Misc.sign(distByFeature[maxDistIndex])));
        }
    }
}

