/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.HowToPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.ReferenceManager;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import edu.berkeley.guir.lib.gesture.util.Matrix;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class OutlierNotice
extends DefaultNotice {
    protected MainFrame mainFrame;
    protected List categoryList;
    protected HowToPanel howToPanel = null;

    public OutlierNotice(MainFrame mf, List outliers, GestureCategory catA, GestureCategory catB) {
        this.mainFrame = mf;
        this.categoryList = new ArrayList();
        this.categoryList.add(catA);
        this.categoryList.add(catB);
        this.categoryList.addAll(outliers);
    }

    protected void displayImpl(SummaryLog log) {
        GestureCategory catA = (GestureCategory)this.categoryList.get(0);
        GestureCategory catB = (GestureCategory)this.categoryList.get(1);
        List outliers = this.categoryList.subList(2, this.categoryList.size());
        int numOutliers = outliers.size();
        log.append("Categories ");
        log.appendLink(catA);
        log.append(" and ");
        log.appendLink(catB);
        log.append(" are likely to be misrecognized because of " + (numOutliers > 1 ? "these categories" : "this category") + ": ");
        this.displayCategories(log, outliers);
        log.append(". Changing " + (numOutliers > 1 ? "them" : "it") + " to be more like ");
        log.appendLink(catA);
        log.append(" and ");
        log.appendLink(catB);
        log.append(" will improve recognition.");
    }

    protected void displayCategories(SummaryLog log, Collection categories) {
        int numCategories = categories.size();
        Iterator iter = categories.iterator();
        while (iter.hasNext()) {
            GestureCategory outlier = (GestureCategory)iter.next();
            if (!iter.hasNext() && numCategories > 1) {
                log.append(numCategories == 2 ? " and " : "and ");
            }
            log.appendLink(outlier);
            if (!iter.hasNext() || numCategories <= 2) continue;
            log.append(", ");
        }
    }

    protected void displaySummaryImpl(SummaryLog log) {
        GestureCategory catA = (GestureCategory)this.categoryList.get(0);
        GestureCategory catB = (GestureCategory)this.categoryList.get(1);
        List outliers = this.categoryList.subList(2, this.categoryList.size());
        log.appendLink(catA);
        log.append(" and ");
        log.appendLink(catB);
        log.append(": ");
        this.displayCategories(log, outliers);
    }

    public List getObjectList() {
        return this.categoryList;
    }

    public String getName() {
        return "Outlying category";
    }

    public String getReferenceTag() {
        return "Outlying Category";
    }

    public HowToPanel getHowToPanel() {
        if (this.howToPanel == null) {
            SummaryLog log = new SummaryLog(this.mainFrame);
            GestureCategory catA = (GestureCategory)this.categoryList.get(0);
            GestureCategory catB = (GestureCategory)this.categoryList.get(1);
            List outliers = this.categoryList.subList(2, this.categoryList.size());
            int numOutliers = outliers.size();
            log.append("To make the gesture categories ");
            log.appendLink(catA);
            log.append(" and ");
            log.appendLink(catB);
            log.append(" easier to recognize, change one or more of the following categories in the recommended way.\n");
            Iterator iter = outliers.iterator();
            while (iter.hasNext()) {
                GestureCategory outlierCat = (GestureCategory)iter.next();
                log.append("\n");
                JComponent thumbnail = DisplayFactory.createThumbnail(outlierCat, log);
                log.append(thumbnail);
                final FeatureInfo info = this.getMostDifferentFeature(catA, catB, outlierCat);
                log.append(" Change this category so its ");
                log.appendLink(info.featureName, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ReferenceManager.getManager().showReference(OutlierNotice.this.mainFrame, info.featureTag);
                    }
                }, "Find out what this feature is");
                log.append(" is " + (info.increaseFeature ? " higher " : " lower ") + ".");
            }
            this.howToPanel = new HowToPanel(this.mainFrame);
            this.howToPanel.add((Component)log, "Center");
        }
        return this.howToPanel;
    }

    protected FeatureInfo getMostDifferentFeature(GestureCategory catA, GestureCategory catB, GestureCategory outlierCat) {
        Classifier classifier = this.mainFrame.getClassifier();
        Class[] featureClasses = classifier.getFeatureClasses();
        double[] A = FeatureFactory.getValues(featureClasses, catA);
        double[] B = FeatureFactory.getValues(featureClasses, catB);
        double[] O = FeatureFactory.getValues(featureClasses, outlierCat);
        double[] diff = Matrix.subtract(Matrix.multiply(0.5, Matrix.add(A, B)), O);
        int index = classifier.findPrincipleComponent(diff);
        FeatureInfo result = new FeatureInfo();
        result.featureTag = ReferenceManager.getFeatureTag(featureClasses[index]);
        result.increaseFeature = diff[index] > 0.0;
        result.featureName = FeatureFactory.getFeatureName(featureClasses[index]);
        if (result.featureName == null) {
            result.featureName = "UNKNOWN";
        }
        return result;
    }

    protected class FeatureInfo {
        String featureTag;
        String featureName;
        boolean increaseFeature;

        protected FeatureInfo() {
        }
    }
}

