/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class NoticeHandler {
    public static final String NOTICE_LIST_PROP = "notice list";
    public static final String NOTICE_DESCENDENTS_PROP = "notice descendents";
    private static final String NOTICE_ICON_FILENAME = "images/warning.png";
    public static final Icon NOTICE_ICON;
    protected GesturePackage gesturePackage;
    protected SummaryLog summaryLog;
    protected PropertyChangeListener propChangeListener = new MyPropChangeListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NOTICE_ICON = new ImageIcon(clazz.getResource(NOTICE_ICON_FILENAME));
        Properties.setPropertyPersistence(NOTICE_LIST_PROP, false);
        Properties.setPropertyPersistence(NOTICE_DESCENDENTS_PROP, false);
    }

    public NoticeHandler(SummaryLog log) {
        this.summaryLog = log;
    }

    public void showNotice(final Notice notice) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showNoticeImpl(notice);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NoticeHandler.this.showNoticeImpl(notice);
                }
            });
        }
    }

    protected void showNoticeImpl(Notice notice) {
        int originalLength = this.summaryLog.length();
        notice.displaySummary(this.summaryLog);
        try {
            notice.setPosition(this.summaryLog.getDocument().createPosition(originalLength));
        }
        catch (BadLocationException e) {
            System.err.println("WARNING: bogus exception (this should never happen): " + e);
        }
    }

    public void registerGesturePackage(GesturePackage pkg) {
        if (this.gesturePackage != null) {
            this.unregisterGesturePackage();
        }
        this.gesturePackage = pkg;
        this.gesturePackage.addPropertyChangeListener(this.propChangeListener);
    }

    public void unregisterGesturePackage() {
        if (this.gesturePackage != null) {
            this.gesturePackage.removePropertyChangeListener(this.propChangeListener);
        }
    }

    public static void addNotice(Notice notice) {
        List gestureObjects = notice.getObjectList();
        Iterator iter = gestureObjects.iterator();
        while (iter.hasNext()) {
            GestureObject gestureObj = (GestureObject)iter.next();
            NoticeHandler.addNotice(gestureObj, notice);
        }
    }

    public static void addNotices(Collection notices) {
        Iterator iter = notices.iterator();
        while (iter.hasNext()) {
            Notice notice = (Notice)iter.next();
            NoticeHandler.addNotice(notice);
        }
    }

    public static void addNotice(GestureObject gestureObj, Notice notice) {
        ArrayList<Notice> noticeList = (ArrayList<Notice>)gestureObj.getProperty(NOTICE_LIST_PROP);
        if (noticeList == null) {
            noticeList = new ArrayList<Notice>();
        }
        noticeList.add(notice);
        gestureObj.setProperty(NOTICE_LIST_PROP, noticeList);
    }

    public static void removeNotice(Notice notice) {
        List gestureObjects = notice.getObjectList();
        Iterator iter = gestureObjects.iterator();
        while (iter.hasNext()) {
            GestureObject gestureObj = (GestureObject)iter.next();
            NoticeHandler.removeNotice(gestureObj, notice);
        }
    }

    public static void removeNotice(GestureObject gestureObj, Notice notice) {
        List noticeList = (List)gestureObj.getProperty(NOTICE_LIST_PROP);
        if (noticeList != null) {
            noticeList.remove(notice);
            gestureObj.setProperty(NOTICE_LIST_PROP, noticeList);
        }
    }

    public static Set getNotices(GestureObject gestureObj) {
        List noticeList = (List)gestureObj.getProperty(NOTICE_LIST_PROP);
        HashSet result = noticeList != null ? new HashSet(noticeList) : new HashSet();
        List noticeDescendents = NoticeHandler.getNoticeDescendents(gestureObj);
        if (noticeDescendents != null) {
            Iterator iter = noticeDescendents.iterator();
            while (iter.hasNext()) {
                GestureObject obj = (GestureObject)iter.next();
                result.addAll((List)obj.getProperty(NOTICE_LIST_PROP));
            }
        }
        return result;
    }

    public static Map getNoticeSummary(GestureObject gestureObj) {
        List noticeList = (List)gestureObj.getProperty(NOTICE_LIST_PROP);
        HashMap result = new HashMap();
        NoticeHandler.addNoticesToSummary(result, noticeList);
        List noticeDescendents = NoticeHandler.getNoticeDescendents(gestureObj);
        if (noticeDescendents != null) {
            Iterator iter = noticeDescendents.iterator();
            while (iter.hasNext()) {
                GestureObject obj = (GestureObject)iter.next();
                List nList = (List)obj.getProperty(NOTICE_LIST_PROP);
                NoticeHandler.addNoticesToSummary(result, nList);
            }
        }
        return result;
    }

    protected static void addNoticesToSummary(Map map, Collection noticeList) {
        if (noticeList != null) {
            Iterator iter = noticeList.iterator();
            while (iter.hasNext()) {
                Notice notice = (Notice)iter.next();
                NoticeHandler.addNoticeToSummary(map, notice);
            }
        }
    }

    protected static void addNoticeToSummary(Map map, Notice notice) {
        Class<?> noticeClass = notice.getClass();
        Set noticeSet = map.containsKey(noticeClass) ? (Set)map.get(noticeClass) : new HashSet();
        noticeSet.add(notice);
        map.put(noticeClass, noticeSet);
    }

    public static boolean hasNotices(GestureObject gestureObj) {
        return Properties.hasNonEmptyCollection(gestureObj, NOTICE_LIST_PROP);
    }

    public static boolean hasNoticesInTree(GestureObject gestureObj) {
        return NoticeHandler.hasNotices(gestureObj) || gestureObj instanceof GestureContainer && Properties.hasNonEmptyCollection(gestureObj, NOTICE_DESCENDENTS_PROP);
    }

    public static Set getNoticesOfClass(GestureObject gestureObj, Class noticeClass) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.Notice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(noticeClass)) {
            throw new IllegalArgumentException("noticeClass must be a Notice");
        }
        Map noticeSummary = NoticeHandler.getNoticeSummary(gestureObj);
        Set result = noticeSummary.containsKey(noticeClass) ? (Set)noticeSummary.get(noticeClass) : new HashSet();
        return result;
    }

    public static List getNoticeDescendents(GestureObject gestureObj) {
        return gestureObj.hasProperty(NOTICE_DESCENDENTS_PROP) ? (List)gestureObj.getProperty(NOTICE_DESCENDENTS_PROP) : null;
    }

    protected static class MyPropChangeListener
    implements PropertyChangeListener {
        protected MyPropChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            PropertyChangeEvent originalEvent = Properties.getRootEvent(e);
            String name = originalEvent.getPropertyName();
            Object oldValue = originalEvent.getOldValue();
            Object newValue = originalEvent.getNewValue();
            if (name == NoticeHandler.NOTICE_LIST_PROP) {
                int newSize;
                List oldList = (List)oldValue;
                List newList = (List)newValue;
                int oldSize = oldList == null ? 0 : oldList.size();
                int n = newSize = newList == null ? 0 : newList.size();
                if (oldSize > 0 && newSize == 0) {
                    MyPropChangeListener.removeNoticeObjFromAncestors(e, (GestureObject)originalEvent.getSource());
                } else if (newSize > 0 && oldSize == 0) {
                    MyPropChangeListener.addNoticeObjToAncestors((GestureObject)originalEvent.getSource());
                }
            } else if (name == "children") {
                GestureObject obj;
                GestureContainer container = (GestureContainer)originalEvent.getSource();
                if (oldValue == null && newValue != null) {
                    GestureObject obj2 = (GestureObject)newValue;
                    if (NoticeHandler.hasNotices(obj2)) {
                        MyPropChangeListener.addNoticeObjToAncestors(obj2);
                    }
                } else if (newValue == null && oldValue != null && NoticeHandler.hasNotices(obj = (GestureObject)oldValue)) {
                    MyPropChangeListener.removeNoticeObjFromAncestors(e, obj);
                    MyPropChangeListener.removeNoticeObjsFromAncestors(e, NoticeHandler.getNoticeDescendents(obj));
                }
            }
        }

        protected static void addNoticeObjToAncestors(GestureObject gestureObj) {
            GestureContainer container = gestureObj.getParent();
            while (container != null) {
                List noticedObjs = container.hasProperty(NoticeHandler.NOTICE_DESCENDENTS_PROP) ? (List)Misc.cloneCollection((Collection)container.getProperty(NoticeHandler.NOTICE_DESCENDENTS_PROP)) : new ArrayList();
                if (!noticedObjs.contains(gestureObj)) {
                    noticedObjs.add(gestureObj);
                    container.setProperty(NoticeHandler.NOTICE_DESCENDENTS_PROP, noticedObjs);
                }
                container = container.getParent();
            }
        }

        protected static void removeNoticeObjFromAncestors(PropertyChangeEvent e, GestureObject gestureObj) {
            while (e != null && e.getPropertyName() == "child changed") {
                GestureContainer container = (GestureContainer)e.getSource();
                List noticedObjs = NoticeHandler.getNoticeDescendents(container);
                noticedObjs.remove(gestureObj);
                container.setProperty(NoticeHandler.NOTICE_DESCENDENTS_PROP, noticedObjs);
                PropertyChangeEvent propertyChangeEvent = e = e.getPropertyName() == "child changed" ? (PropertyChangeEvent)e.getNewValue() : null;
            }
        }

        protected static void removeNoticeObjsFromAncestors(PropertyChangeEvent e, List objList) {
            if (objList != null) {
                Iterator iter = objList.iterator();
                while (iter.hasNext()) {
                    MyPropChangeListener.removeNoticeObjFromAncestors(e, (GestureObject)iter.next());
                }
            }
        }
    }
}

