/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.GInternalFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureContainerPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.HowToPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.ShadowGestureContainer;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class MisrecognitionNotice
extends DefaultNotice {
    private List misrecogGestures;
    private MainFrame mainFrame;
    private ActionListener showExamplesListener = null;
    private HowToPanel howToPanel = null;

    public MisrecognitionNotice(MainFrame mf, List misrecognizedGestures) {
        this.mainFrame = mf;
        this.misrecogGestures = misrecognizedGestures;
        this.showExamplesListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShadowGestureContainer container = new ShadowGestureContainer(MisrecognitionNotice.this.misrecogGestures);
                container.setName("Misrecognized gestures");
                JScrollPane scrollPane = new JScrollPane();
                MisrecogGestureContainerPanel panel = new MisrecogGestureContainerPanel(container, scrollPane);
                GInternalFrame iFrame = GInternalFrame.makeInternalFrame(container, panel, scrollPane);
                MisrecognitionNotice.this.mainFrame.getDesktop().showFrame(iFrame);
            }
        };
    }

    public boolean hasExpired() {
        return this.misrecogGestures.size() == 0;
    }

    protected void displayImpl(SummaryLog log) {
        if (!this.hasExpired()) {
            log.append("There are " + this.misrecogGestures.size() + " ");
            log.appendLink("misrecognized gestures", this.showExamplesListener, "Make a new view for the misrecognized gestures");
            log.append(". This probably indicates either mistakes in entering the gestures, or that the gesture categories are too similar to each other.");
        }
    }

    protected void displaySummaryImpl(SummaryLog log) {
        log.appendLink(String.valueOf(this.misrecogGestures.size()) + " misrecognized gestures", this.showExamplesListener, "Make a new view for the misrecognized gestures");
    }

    public String getName() {
        return "Misrecognized gestures";
    }

    public List getObjectList() {
        return this.misrecogGestures;
    }

    public String getReferenceTag() {
        return "Misrecognition";
    }

    public HowToPanel getHowToPanel() {
        if (this.howToPanel == null) {
            this.howToPanel = new MisrecognitionExplanationPanel();
        }
        return this.howToPanel;
    }

    protected static class MisrecogGestureContainerPanel
    extends GestureContainerPanel {
        protected static final Border BORDER = BorderFactory.createEtchedBorder();

        public MisrecogGestureContainerPanel(ShadowGestureContainer container, JScrollPane scroller) {
            super(container, scroller);
        }

        protected void addGestureObject(GestureObject gestureObj, JScrollPane scrollPane, int index) {
            Gesture gesture = (Gesture)gestureObj;
            GestureObjectPanel gesturePanel = (GestureObjectPanel)DisplayFactory.create(gestureObj, scrollPane);
            JLabel label = new JLabel(gesture.getParent().getName());
            label.setForeground(Color.green.darker().darker());
            gesturePanel.add((Component)label, "North");
            gesturePanel.setBorder(BORDER);
            this.add((Component)gesturePanel, index);
        }

        public boolean isCommandValid(int id) {
            boolean valid;
            switch (id) {
                case 203: 
                case 404: 
                case 408: {
                    valid = false;
                    break;
                }
                default: {
                    valid = super.isCommandValid(id);
                }
            }
            return valid;
        }
    }

    public class MisrecognitionExplanationPanel
    extends HowToPanel {
        SummaryLog log = new SummaryLog(null);

        public MisrecognitionExplanationPanel() {
            this.buildUI();
        }

        protected void buildUI() {
            this.add((Component)this.log, "Center");
            this.setPreferredSize(new Dimension(300, 300));
            this.log.append("To fix misrecognition problems, first look over the ");
            this.log.appendLink("examples", MisrecognitionNotice.this.showExamplesListener, "Make a new view of the examples");
            this.log.append(" and see if any of them were drawn the way they were by mistake.  If they were, you should delete them and probably redraw them.\n");
            this.log.append("If there are no mistaken examples, or if fixing mistaken ones does not help, then it may be that the two gestures are too similar.  You may want to make them more different.");
        }
    }
}

