/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureFile;
import edu.berkeley.guir.lib.gesture.GestureInteractor;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.gesture.apps.gdt.Analyzers;
import edu.berkeley.guir.lib.gesture.apps.gdt.Commander;
import edu.berkeley.guir.lib.gesture.apps.gdt.CompositeGestureTree;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureAcceptor;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureDesktop;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTree;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTreeModel;
import edu.berkeley.guir.lib.gesture.apps.gdt.HumanGoodness;
import edu.berkeley.guir.lib.gesture.apps.gdt.MisrecognitionNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.NoticeHandler;
import edu.berkeley.guir.lib.gesture.apps.gdt.RecognizerGoodness;
import edu.berkeley.guir.lib.gesture.apps.gdt.ReferenceManager;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import edu.berkeley.guir.lib.gesture.apps.gdt.SwingWorker;
import edu.berkeley.guir.lib.gesture.apps.gdt.WindowManager;
import edu.berkeley.guir.lib.gesture.util.CollectionEvent;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import edu.berkeley.guir.lib.gesture.util.Gensym;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame
implements GDTConstants {
    private static Map fileErrors = new HashMap();
    public static final String NOTICE_VISIBILITY_CHANGE_PROP = "NOTICE_VISIBILITY_CHANGE_PROP";
    private static final String ACTION_ID = "action id";
    protected GestureFile gestureFile = null;
    protected GesturePackage gesturePackage = null;
    protected PageFormat pageFormat = null;
    protected Classifier classifier = null;
    protected GestureCategory recognizedCategory = null;
    protected boolean trainingInProgress = false;
    protected SwingWorker trainingWorker = null;
    protected SwingWorker testWorker = null;
    protected int dataReaderCount = 0;
    protected int busyCount = 0;
    protected static boolean debugMenuExists;
    protected static boolean warningsEnabled;
    protected Analyzers analyzers = new Analyzers(this);
    protected HumanGoodness humanGoodness = null;
    protected RecognizerGoodness recognizerGoodness = null;
    protected final int SAVED = 2;
    protected final int AUTOSAVED = 1;
    protected final int NOT_SAVED = 0;
    protected int saveLevel = 2;
    protected String lastDirectory = ".";
    protected static int autoSaveInterval;
    protected boolean useAutoSave = true;
    protected SummaryLog summaryLog = null;
    protected NoticeHandler noticeHandler = null;
    protected GestureInteractor inputArea = null;
    protected CompositeGestureTree gestureTrees = null;
    protected GestureTree trainingTree = null;
    protected GestureTree testTree = null;
    protected GestureDesktop desktop = null;
    protected Vector childCommanders = new Vector();
    protected JMenuItem trainMenuItem;
    protected JMenuItem testMenuItem;
    protected JCheckBoxMenuItem warningsToggleMenuItem;
    protected JLabel recognizerGoodnessLabel;
    protected JLabel humanGoodnessLabel;
    protected List currentSelection = null;
    protected JComponent selectionDisplay = null;
    protected boolean inUpdateSelection = false;
    protected PropertyChangeListener propChangeListener = new MyPropertyChangeListener();
    protected CollectionListener collectionListener = new MyCollectionListener();
    protected PropertyChangeListener classifierListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e) {
            MainFrame.this.updateMenuItem(MainFrame.this.trainMenuItem);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GestureFile$UnsupportedVersionException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz, "That file version cannot be read.");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.ClassNotFoundException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz2, "A required class was not found (corrupted file?).");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.io.InvalidClassException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz3, "Couldn't parse a class (corrupted file?).");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.io.InvalidObjectException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz4, "Couldn't parse an object (corrupted file?).");
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.io.IOException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz5, "File I/O error.");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.io.FileNotFoundException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz6, "File not found.");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.text.ParseException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileErrors.put(clazz7, "Parse error (probably an ill-formed number).");
        debugMenuExists = true;
        warningsEnabled = true;
        autoSaveInterval = 300000;
    }

    public MainFrame() {
        this((GestureFile)null);
    }

    public MainFrame(GestureFile f) {
        this.buildUI();
        if (f != null) {
            this.openFile(f);
        } else {
            this.setFile(f);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (MainFrame.this.doClose()) {
                    MainFrame.this.dispose();
                }
            }
        });
        this.updateMenuBar();
        AbstractAction autoSaveAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.doAutoSaveIfNecessary();
            }
        };
        new Timer(autoSaveInterval, autoSaveAction).start();
    }

    protected void buildUI() {
        JMenuBar menuBar = this.buildMenuBar();
        this.getRootPane().setJMenuBar(menuBar);
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        JSplitPane logSplitter = new JSplitPane(0, true);
        logSplitter.setResizeWeight(0.7);
        contents.add((Component)logSplitter, "Center");
        this.summaryLog = new SummaryLog(this);
        this.summaryLog.setPreferredSize(new Dimension(200, 50));
        logSplitter.setBottomComponent(this.summaryLog);
        this.noticeHandler = new NoticeHandler(this.summaryLog);
        JSplitPane centerArea = new JSplitPane(1, true);
        centerArea.setResizeWeight(0.33);
        logSplitter.setTopComponent(centerArea);
        JSplitPane leftPane = new JSplitPane(0, true);
        leftPane.setResizeWeight(0.75);
        centerArea.setLeftComponent(leftPane);
        this.inputArea = new GestureInteractor();
        this.inputArea.setMinimumSize(new Dimension(50, 50));
        this.inputArea.setEnabled(false);
        this.inputArea.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (((GestureAcceptor)((Object)MainFrame.this.selectionDisplay)).gestureDrawn(MainFrame.this.inputArea.getGesture())) {
                    MainFrame.this.inputArea.setGesture(null);
                }
            }
        });
        leftPane.setBottomComponent(this.inputArea);
        this.gestureTrees = new CompositeGestureTree();
        this.trainingTree = this.gestureTrees.getTrainingTree();
        this.testTree = this.gestureTrees.getTestTree();
        ChangeListener standardMenuChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MainFrame.this.updateMenuBar();
            }
        };
        this.installTree(this.trainingTree, standardMenuChangeListener);
        this.installTree(this.testTree, standardMenuChangeListener);
        this.gestureTrees.setPreferredSize(new Dimension(200, 400));
        JPanel treePanel = new JPanel(new BorderLayout());
        JPanel metricsPanel = this.buildMetricsPanel();
        treePanel.add((Component)metricsPanel, "North");
        treePanel.add((Component)this.gestureTrees, "Center");
        leftPane.setTopComponent(treePanel);
        this.inputArea.setPreferredSize(new Dimension(150, 150));
        this.desktop = new GestureDesktop();
        this.desktop.setMinimumSize(new Dimension(50, 50));
        this.desktop.setPreferredSize(new Dimension(300, 300));
        this.desktop.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainFrame.this.updateSelection(MainFrame.this.desktop);
                MainFrame.this.updateInputArea();
            }
        });
        this.desktop.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MainFrame.this.updateSelection(MainFrame.this.desktop);
            }
        });
        this.desktop.addMenuValidChangeListener(standardMenuChangeListener);
        this.selectionDisplay = this.desktop;
        this.childCommanders.add(this.desktop);
        centerArea.setRightComponent(this.desktop);
        this.updateMenuBar();
        this.updateInputArea();
    }

    protected JPanel buildMetricsPanel() {
        Border padding = BorderFactory.createEmptyBorder(0, 0, 0, 5);
        JPanel result = new JPanel(new GridLayout(2, 1));
        JPanel humanPanel = new JPanel(new BorderLayout());
        JLabel humanLabel = new JLabel("Human goodness");
        this.humanGoodnessLabel = new JLabel("?");
        this.humanGoodnessLabel.setHorizontalAlignment(4);
        this.humanGoodnessLabel.setBorder(padding);
        humanPanel.add((Component)humanLabel, "West");
        humanPanel.add((Component)this.humanGoodnessLabel, "Center");
        humanPanel.setToolTipText("How well humans will be able to learn and remember the gestures.  1000 is the best value.");
        result.add(humanPanel);
        JPanel recognizerPanel = new JPanel(new BorderLayout());
        JLabel recognizerLabel = new JLabel("Recognizer goodness");
        this.recognizerGoodnessLabel = new JLabel("?");
        this.recognizerGoodnessLabel.setHorizontalAlignment(4);
        this.recognizerGoodnessLabel.setBorder(padding);
        recognizerPanel.setToolTipText("How easily the computer can recognize the gestures.  1000 is the best value.");
        recognizerPanel.add((Component)recognizerLabel, "West");
        recognizerPanel.add((Component)this.recognizerGoodnessLabel, "Center");
        result.add(recognizerPanel);
        return result;
    }

    protected void installTree(final GestureTree tree, ChangeListener standardMenuChangeListener) {
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                MainFrame.this.updateSelection(tree);
                MainFrame.this.updateInputArea();
            }
        };
        tree.addTreeSelectionListener(treeSelectionListener);
        tree.addMenuValidChangeListener(standardMenuChangeListener);
        this.childCommanders.add(tree);
    }

    public static void setWarningsEnabled(boolean on) {
        warningsEnabled = on;
    }

    public static boolean areWarningsEnabled() {
        return warningsEnabled;
    }

    public boolean areNoticesVisible() {
        return MainFrame.areWarningsEnabled() && this.warningsToggleMenuItem.getState();
    }

    public static void setDebugMenu(boolean on) {
        debugMenuExists = on;
    }

    private JMenuItem addMenuItem(JMenu menu, final int actionID, String label) {
        AbstractAction action = new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.doCommand(actionID);
            }
        };
        action.putValue(ACTION_ID, new Integer(actionID));
        JMenuItem item = new JMenuItem(action);
        menu.add(item);
        return item;
    }

    private JMenuItem addMenuItem(JMenu menu, int actionID, final String enabledLabel, final String disabledLabel) {
        final JMenuItem item = this.addMenuItem(menu, actionID, enabledLabel);
        item.getAction().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("enabled")) {
                    boolean value = (Boolean)e.getNewValue();
                    item.setText(value ? enabledLabel : disabledLabel);
                }
            }
        });
        return item;
    }

    private JMenuItem addMenuItem(JMenu menu, int actionID, String label, char key, int modifiers) {
        JMenuItem item = this.addMenuItem(menu, actionID, label);
        String stringCode = "" + Character.toUpperCase(key);
        KeyStroke tempStroke = KeyStroke.getKeyStroke(stringCode);
        item.setAccelerator(KeyStroke.getKeyStroke(tempStroke.getKeyCode(), modifiers));
        return item;
    }

    private JMenuItem addMenuItem(JMenu menu, int actionID, String label, int keyCode, int modifiers) {
        JMenuItem item = this.addMenuItem(menu, actionID, label);
        item.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
        return item;
    }

    private JCheckBoxMenuItem addCBMenuItem(JMenu menu, final int actionID, String label, boolean on) {
        AbstractAction action = new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.doCommand(actionID);
            }
        };
        action.putValue(ACTION_ID, new Integer(actionID));
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setState(on);
        menu.add(item);
        return item;
    }

    protected JMenuBar buildMenuBar() {
        int modifiers = 8;
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        this.addMenuItem(menu, 110, "New Package");
        menu.addSeparator();
        this.addMenuItem(menu, 101, "Open...", 79, modifiers);
        this.addMenuItem(menu, 102, "Save", 's', modifiers);
        this.addMenuItem(menu, 103, "Save As...");
        menu.addSeparator();
        this.addMenuItem(menu, 107, "Page Setup...");
        this.addMenuItem(menu, 106, "Print...", 'p', modifiers);
        menu.addSeparator();
        this.addMenuItem(menu, 108, "Close", 'w', modifiers);
        this.addMenuItem(menu, 109, "Quit", 'q', modifiers);
        mb.add(menu);
        menu = new JMenu("Edit");
        this.addMenuItem(menu, 201, "Cut", 'x', modifiers);
        this.addMenuItem(menu, 202, "Copy", 'c', modifiers);
        this.addMenuItem(menu, 203, "Paste", 'v', modifiers);
        this.addMenuItem(menu, 204, "Delete", 'd', modifiers);
        mb.add(menu);
        menu = new JMenu("View");
        this.addMenuItem(menu, 301, "New View");
        if (warningsEnabled) {
            menu.addSeparator();
            this.warningsToggleMenuItem = this.addCBMenuItem(menu, 302, "Show Suggestions", true);
            this.addMenuItem(menu, 303, "Clear Suggestions");
        }
        mb.add(menu);
        menu = new JMenu("Gesture");
        this.addMenuItem(menu, 401, "New Gesture Category");
        this.addMenuItem(menu, 402, "New Group");
        this.addMenuItem(menu, 111, "New Test Set");
        menu.addSeparator();
        this.addMenuItem(menu, 403, "Rename...");
        this.addMenuItem(menu, 404, "Enable");
        this.addMenuItem(menu, 408, "Disable");
        menu.addSeparator();
        this.trainMenuItem = this.addMenuItem(menu, 405, "Train Set", "Set Is Trained");
        this.addMenuItem(menu, 406, "Analyze Set");
        this.testMenuItem = this.addMenuItem(menu, 407, "Test Recognition");
        mb.add(menu);
        if (debugMenuExists) {
            menu = new JMenu("Debug");
            this.addMenuItem(menu, 0x100001, "Validate Parents");
            this.addMenuItem(menu, 0x100002, "Dump Human Coordinates");
            mb.add(menu);
        }
        menu = new JMenu("Help");
        this.addMenuItem(menu, 601, "Tutorial");
        this.addMenuItem(menu, 602, "Reference");
        menu.addSeparator();
        this.addMenuItem(menu, 603, "About");
        mb.add(menu);
        return mb;
    }

    public void doCommand(int actionID) {
        switch (actionID) {
            case 110: {
                MainFrame newFrame = WindowManager.createMainFrame();
                newFrame.pack();
                newFrame.show();
                this.updateMenuBar();
                newFrame.updateMenuBar();
                break;
            }
            case 111: {
                this.doNewTestSet();
                break;
            }
            case 101: {
                this.doOpen();
                break;
            }
            case 102: {
                if (this.gestureFile != null) {
                    this.doSave();
                    break;
                }
                this.doSaveAs();
                break;
            }
            case 103: {
                this.doSaveAs();
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 107: {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                if (this.pageFormat == null) {
                    this.pageFormat = printJob.defaultPage();
                }
                this.pageFormat = printJob.pageDialog(this.pageFormat);
                break;
            }
            case 106: {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                final JInternalFrame activeFrame = this.desktop.getSelectedFrame();
                printJob.setPrintable(new Printable(){

                    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                        if (pageIndex > 0) {
                            return 1;
                        }
                        ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                        activeFrame.paint(graphics);
                        return 0;
                    }
                });
                if (!printJob.printDialog()) break;
                try {
                    printJob.print();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 108: {
                if (!this.doClose()) break;
                this.dispose();
                break;
            }
            case 109: {
                if (!WindowManager.closeAll()) break;
                System.exit(0);
                break;
            }
            case 207: {
                break;
            }
            case 301: {
                if (this.currentSelection == null) break;
                Iterator iter = this.currentSelection.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof GestureObject)) continue;
                    this.desktop.showFrame((GestureObject)obj);
                }
                break;
            }
            case 302: {
                warningsEnabled = this.warningsToggleMenuItem.getState();
                this.trainingTree.invalidate();
                this.trainingTree.repaint();
                this.testTree.invalidate();
                this.testTree.repaint();
                this.desktop.repaint();
                this.firePropertyChange(NOTICE_VISIBILITY_CHANGE_PROP, new Boolean(!warningsEnabled), new Boolean(warningsEnabled));
                break;
            }
            case 303: {
                this.summaryLog.clear();
                break;
            }
            case 405: {
                this.train();
                break;
            }
            case 406: {
                break;
            }
            case 407: {
                this.testRecognition();
                break;
            }
            case 0x100001: {
                this.doValidateParents();
                break;
            }
            case 601: {
                ReferenceManager.getManager().showTutorial(this);
                break;
            }
            case 602: {
                ReferenceManager.getManager().showReferenceManual(this);
                break;
            }
            case 603: {
                this.showAboutBox();
                break;
            }
            default: {
                Commander selectionHolder = (Commander)((Object)this.selectionDisplay);
                if (selectionHolder == null) break;
                selectionHolder.doCommand(actionID);
            }
        }
    }

    public boolean isCommandValid(int actionID) {
        boolean valid;
        switch (actionID) {
            case 101: 
            case 110: 
            case 111: {
                valid = true;
                break;
            }
            case 102: {
                valid = this.saveLevel != 2;
                break;
            }
            case 103: 
            case 104: 
            case 106: 
            case 107: {
                valid = true;
                break;
            }
            case 108: {
                valid = WindowManager.getFrameCount() > 1;
                break;
            }
            case 109: {
                valid = true;
                break;
            }
            case 207: {
                valid = false;
                break;
            }
            case 105: {
                valid = false;
                break;
            }
            case 301: {
                valid = this.currentSelection != null && this.currentSelection.size() > 0;
                break;
            }
            case 302: 
            case 303: {
                valid = true;
                break;
            }
            case 304: 
            case 305: 
            case 306: {
                valid = false;
                break;
            }
            case 405: {
                valid = this.classifier != null && !this.classifier.isTrained() && !this.trainingInProgress;
                break;
            }
            case 406: {
                valid = false;
                break;
            }
            case 407: {
                valid = false;
                if (this.currentSelection == null) break;
                Iterator iter = this.currentSelection.iterator();
                while (iter.hasNext() && !valid) {
                    Object obj = iter.next();
                    if (!(obj instanceof GestureObject)) continue;
                    valid = true;
                }
                break;
            }
            case 0x100001: {
                valid = this.currentSelection != null && this.currentSelection.size() > 0;
                break;
            }
            case 601: 
            case 602: 
            case 603: {
                valid = true;
                break;
            }
            default: {
                Commander selectionHolder = (Commander)((Object)this.selectionDisplay);
                valid = selectionHolder != null ? selectionHolder.isCommandValid(actionID) : false;
            }
        }
        return valid;
    }

    private void doNewTestSet() {
        System.out.println("MF: doNewTestSet");
        GestureSet gs = new GestureSet();
        gs.setName(Gensym.next("testset"));
        this.copyStructure(gs, this.gesturePackage.getTrainingSet());
        this.gesturePackage.getTestSets().add(gs);
    }

    private void copyStructure(GestureContainer newContainer, GestureContainer oldContainer) {
        Iterator iter = oldContainer.iterator();
        while (iter.hasNext()) {
            GestureObject obj = (GestureObject)iter.next();
            if (!(obj instanceof GestureContainer)) continue;
            GestureContainer oldChild = (GestureContainer)obj;
            GestureContainer newChild = null;
            try {
                newChild = (GestureContainer)oldChild.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (newChild == null) {
                this.message("WARNING: There was a problem making a new container like '" + oldContainer.getName() + "'.\n");
                continue;
            }
            newChild.setName(oldChild.getName());
            this.copyStructure(newChild, oldChild);
            newContainer.add(newChild);
        }
    }

    private void doValidateParents() {
        if (this.currentSelection != null) {
            this.doValidateParents(this.currentSelection.iterator(), "SELECTION");
        }
    }

    private void doValidateParents(Iterator children, String parentName) {
        int i = 0;
        while (children.hasNext()) {
            Object obj = children.next();
            if (obj instanceof Gesture) {
                Gesture gesture = (Gesture)obj;
                if (gesture.getParent() == null) {
                    System.out.println("No parent for gesture #" + i + " of " + parentName);
                }
            } else if (obj instanceof GestureContainer) {
                GestureContainer container = (GestureContainer)obj;
                if (container.getParent() == null) {
                    System.out.println("No parent for child " + container.getName() + " of " + parentName);
                }
                this.doValidateParents(container.iterator(), container.getName());
            }
            ++i;
        }
    }

    private void openFile(final GestureFile gf) {
        boolean tempDisableAutosave = false;
        if (gf.doesNewerAutoSaveExist()) {
            int option = JOptionPane.showConfirmDialog(this, "Autosave file exists for file '" + gf.getFile() + "' (and is newer).  Use autosave file?", "Use autosave file?", 0);
            switch (option) {
                case 1: {
                    gf.setUseAutosave(false);
                    break;
                }
                case 0: {
                    this.message("Loading autosave file for '" + gf.getFile() + "'.");
                    this.message("Further autosave disabled until the file is saved.");
                    tempDisableAutosave = true;
                }
            }
        }
        final boolean disableAutosave = tempDisableAutosave;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                Object result;
                try {
                    gf.read();
                    result = gf;
                }
                catch (Exception e) {
                    result = e;
                }
                return result;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void finished() {
                try {
                    Object result = this.getValue();
                    if (result instanceof Exception) {
                        if (result instanceof FileNotFoundException) {
                            String m = "Couldn't find file '" + gf.getFile().getName() + "'.";
                            MainFrame.this.message(m);
                            MainFrame.this.showErrorDialog("File not found", m, (Exception)result);
                        } else {
                            MainFrame.this.showErrorDialog("File read error", String.valueOf(gf.getFile().getName()) + ": Internal error while reading file." + "  (This should never happen.) " + result, (Exception)result);
                        }
                    } else if (result instanceof GestureFile) {
                        MainFrame.this.lastDirectory = gf.getFile().getParent();
                        if (MainFrame.this.gestureFile == null && MainFrame.this.saveLevel == 2) {
                            MainFrame.this.setFile(gf);
                            MainFrame.this.setSaveLevel(gf.wasAutoSaveRead() ? 1 : 2);
                            MainFrame.this.useAutoSave = !disableAutosave;
                        } else {
                            MainFrame newFrame = WindowManager.createMainFrame(gf);
                            newFrame.setSaveLevel(gf.wasAutoSaveRead() ? 1 : 2);
                            newFrame.useAutoSave = !disableAutosave;
                            newFrame.pack();
                            newFrame.show();
                            MainFrame.this.updateMenuBar();
                            newFrame.updateMenuBar();
                        }
                    } else {
                        System.err.println("BOGUS: file open SwingWorker returned non-Exception, non-GestureFile value: " + result);
                        MainFrame.this.showErrorDialog("File open error", String.valueOf(gf.getFile().getName()) + ": Internal error while reading file." + "  (This should never happen.) " + result, (Exception)result);
                    }
                    Object var3_6 = null;
                    MainFrame.this.lessBusy();
                    return;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    MainFrame.this.lessBusy();
                    throw throwable;
                }
            }
        };
        this.moreBusy();
        worker.start();
    }

    private void doOpen() {
        JFileChooser fileChooser = new JFileChooser(this.lastDirectory);
        fileChooser.addChoosableFileFilter(GestureFile.getFileFilter());
        int returnVal = fileChooser.showOpenDialog(this);
        switch (returnVal) {
            case 0: {
                GestureFile gf = new GestureFile(fileChooser.getSelectedFile());
                this.openFile(gf);
                break;
            }
            case 1: {
                this.message("Open cancelled");
                break;
            }
            default: {
                System.err.println("Bogosity from JFileChooser");
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAutoSaveIfNecessary() {
        if (this.saveLevel != 0) return;
        if (this.gestureFile == null) return;
        if (!this.useAutoSave) return;
        this.summaryLog.append("Autosaving...");
        try {
            try {
                this.gestureFile.writeAutoSave();
                this.setSaveLevel(1);
                this.summaryLog.append("done.");
            }
            catch (IOException e) {
                this.showFileErrorDialog(this.gestureFile.getFile(), "Error saving file", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.summaryLog.append("\n");
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.summaryLog.append("\n");
            return;
        }
    }

    private void removeAutoSaveFile() {
        File autoSaveFile;
        if (this.gestureFile != null && (autoSaveFile = this.gestureFile.getAutoSaveFile()).exists() && autoSaveFile.delete()) {
            this.message("Could not delete auto save file '" + autoSaveFile + "'");
        }
    }

    private void doSave() {
        try {
            this.gestureFile.write();
            this.setSaveLevel(2);
            this.useAutoSave = true;
            this.removeAutoSaveFile();
        }
        catch (IOException e) {
            this.showFileErrorDialog(this.gestureFile.getFile(), "Error saving file", e);
        }
    }

    private void doSaveAs() {
        JFileChooser fileChooser = new JFileChooser(this.lastDirectory);
        fileChooser.setDialogTitle("Save As");
        fileChooser.addChoosableFileFilter(GestureFile.getFileFilter());
        int returnVal = fileChooser.showSaveDialog(this);
        switch (returnVal) {
            case 0: {
                File saveFile = fileChooser.getSelectedFile();
                if (saveFile.exists()) {
                    int option = JOptionPane.showConfirmDialog(this, "File '" + saveFile + "' exists.  Overwrite it?", "Overwrite file?", 0);
                    switch (option) {
                        case 1: {
                            this.message("Save As cancelled");
                            return;
                        }
                    }
                }
                this.gestureFile = new GestureFile(saveFile, this.gesturePackage);
                this.gesturePackage.setName(saveFile.getName());
                this.doSave();
                this.updateTitle();
                this.lastDirectory = saveFile.getParent();
                break;
            }
            case 1: {
                this.message("Save As cancelled");
                break;
            }
            default: {
                System.err.println("Bogosity from JFileChooser");
            }
        }
    }

    public boolean doClose() {
        boolean result = true;
        if (this.saveLevel != 2) {
            int option = JOptionPane.showConfirmDialog(this, "Package '" + this.gesturePackage.getName() + "' has changed since" + " it was last saved.  Save it now?", "Save file?", 1);
            switch (option) {
                case 0: {
                    if (this.gestureFile == null) {
                        this.doSaveAs();
                        break;
                    }
                    this.doSave();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        this.removeAutoSaveFile();
        return result;
    }

    private void setSaveLevel(int newLevel) {
        if (newLevel != this.saveLevel) {
            File asFile;
            this.saveLevel = newLevel;
            this.updateTitle();
            this.updateMenuBar();
            if (this.saveLevel == 2 && this.gestureFile != null && (asFile = this.gestureFile.getAutoSaveFile()).exists()) {
                asFile.delete();
            }
        }
    }

    public void setFile(GestureFile f) {
        this.gestureFile = f;
        if (f == null) {
            GesturePackage pkg = new GesturePackage();
            pkg.setName("(unnamed)");
            this.setGesturePackage(pkg);
        } else {
            this.setGesturePackage(this.gestureFile.getGesturePackage());
        }
        this.updateTitle();
    }

    public GestureDesktop getDesktop() {
        return this.desktop;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public GesturePackage getGesturePackage() {
        return this.gesturePackage;
    }

    public void setGesturePackage(GesturePackage gp) {
        if (this.gesturePackage != gp) {
            if (this.gesturePackage != null) {
                this.classifier.removePropertyChangeListener(this.classifierListener);
                this.gesturePackage.removePropertyChangeListener(this.propChangeListener);
                this.gesturePackage.removeCollectionListener(this.collectionListener);
                this.noticeHandler.unregisterGesturePackage();
            }
            this.gesturePackage = gp;
            this.gestureTrees.setModel(new GestureTreeModel(this.gesturePackage));
            if (this.gesturePackage != null) {
                GestureSet trainingSet = this.gesturePackage.getTrainingSet();
                this.classifier = new Classifier(trainingSet);
                this.classifier.addPropertyChangeListener(this.classifierListener);
                this.gesturePackage.addPropertyChangeListener(this.propChangeListener);
                this.gesturePackage.addCollectionListener(this.collectionListener);
                this.noticeHandler.registerGesturePackage(this.gesturePackage);
                this.humanGoodness = new HumanGoodness(trainingSet);
                this.recognizerGoodness = new RecognizerGoodness(trainingSet);
            } else {
                this.classifier = null;
                this.humanGoodness = null;
                this.recognizerGoodness = null;
            }
            this.analyzers.restartTasks();
        }
    }

    public SummaryLog getSummaryLog() {
        return this.summaryLog;
    }

    private void updateTitle() {
        String name = this.gestureFile == null ? "(unnamed)" : this.gestureFile.getFile().getName();
        String saveState = this.saveLevel == 2 ? "" : " (*)";
        String title = String.valueOf(name) + saveState + " - gdt";
        this.setTitle(title);
    }

    public void showFileErrorDialog(File f, String message, Exception e) {
        this.showErrorDialog("File error", "Error accessing file '" + f + "':" + message, e);
    }

    public void showErrorDialog(final String title, final String message, final Exception exception) {
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                if (exception == null) {
                    JOptionPane.showMessageDialog(MainFrame.this, message, title, 0);
                } else {
                    Object[] options = new Object[]{"Ok", "Dump stack"};
                    int choice = JOptionPane.showOptionDialog(MainFrame.this, message, title, -1, 0, null, options, options[0]);
                    if (choice == 1) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    protected void showPath(TreePath path) {
        if (path != null) {
            TreePath[] paths = new TreePath[]{path};
            this.showPaths(paths);
        }
    }

    protected void showPaths(TreePath[] paths) {
        int i = 0;
        while (i < paths.length) {
            Object lastComponent = paths[i].getLastPathComponent();
            Object selectedObj = GestureTree.getUserObject(lastComponent);
            if (selectedObj != null) {
                int pathLength = paths[i].getPathCount();
                if (selectedObj instanceof GestureObject) {
                    GestureContainer parent = ((GestureObject)selectedObj).getParent();
                    String parentName = parent != null ? parent.getName() : "(none)";
                    this.desktop.showFrame((GestureObject)selectedObj, parentName);
                } else {
                    System.out.println("Can't display " + selectedObj + "[" + selectedObj.getClass().getName() + "]");
                }
            }
            ++i;
        }
    }

    public void message(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.summaryLog.message(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.summaryLog.message(string);
                }
            });
        }
    }

    public void updateMetrics() {
        String humanString = this.humanGoodness != null ? Misc.toString(this.humanGoodness.getGoodness(), 3) : "N/A";
        String recognizerString = this.recognizerGoodness != null ? Misc.toString(this.recognizerGoodness.getGoodness(), 3) : "N/A";
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateMetricsImpl(humanString, recognizerString);
        } else {
            final String h = humanString;
            final String r = recognizerString;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.updateMetricsImpl(h, r);
                }
            });
        }
    }

    protected void updateMetricsImpl(String humanString, String recognizerString) {
        this.humanGoodnessLabel.setText(humanString);
        this.humanGoodnessLabel.setForeground(Color.black);
        this.humanGoodnessLabel.repaint();
        this.recognizerGoodnessLabel.setText(recognizerString);
        this.recognizerGoodnessLabel.setForeground(Color.black);
        this.recognizerGoodnessLabel.repaint();
    }

    public Analyzers getAnalyzers() {
        return this.analyzers;
    }

    public NoticeHandler getNoticeHandler() {
        return this.noticeHandler;
    }

    private void packageChanged() {
        System.out.println("packageChanged");
        if (this.trainingInProgress) {
            System.err.println("BOGOSITY: the set was changed during training");
        }
        this.setSaveLevel(0);
        this.updateTitle();
        this.updateInputArea();
        this.updateMenuBar();
        this.humanGoodnessLabel.setForeground(Color.darkGray);
        this.recognizerGoodnessLabel.setForeground(Color.darkGray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateSelection(JComponent origin) {
        if (this.inUpdateSelection) return;
        try {
            this.inUpdateSelection = true;
            if (this.selectionDisplay != origin) {
                if (this.selectionDisplay == this.desktop) {
                    JInternalFrame selectedFrame = this.desktop.getSelectedFrame();
                    if (selectedFrame != null) {
                        try {
                            selectedFrame.setSelected(false);
                        }
                        catch (PropertyVetoException e) {}
                    }
                } else if (this.selectionDisplay instanceof GestureTree) {
                    ((GestureTree)this.selectionDisplay).clearSelection();
                } else if (this.selectionDisplay != null) {
                    System.err.println("ERROR: selection owned by unknown widget: " + this.selectionDisplay);
                }
                this.selectionDisplay = origin;
            }
            if (this.selectionDisplay == this.desktop) {
                this.currentSelection = this.desktop.getSelectedGestureObjects();
            } else if (this.selectionDisplay instanceof GestureTree) {
                this.currentSelection = ((GestureTree)this.selectionDisplay).getSelectedObjects();
            } else {
                System.err.println("ERROR: selection changed by unknown widget: " + this.selectionDisplay);
            }
            this.updateMenuBar();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.inUpdateSelection = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.inUpdateSelection = false;
            return;
        }
    }

    protected void updateInputArea() {
        GestureAcceptor acceptor = (GestureAcceptor)((Object)this.selectionDisplay);
        boolean on = !this.trainingInProgress && acceptor.canAcceptGesture();
        this.inputArea.setEnabled(on);
        TitledBorder newBorder = on ? BorderFactory.createTitledBorder(null, acceptor.getInputGestureTitle()) : (this.trainingInProgress ? BorderFactory.createTitledBorder(null, "Training in progress...") : null);
        this.inputArea.setBorder(newBorder);
    }

    protected void updateMenuBar() {
        JMenuBar mb = this.getRootPane().getJMenuBar();
        this.updateMenuElements(mb.getSubElements());
    }

    protected void updateMenuElements(MenuElement[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                Component comp = elements[i].getComponent();
                if (comp instanceof JMenuItem) {
                    this.updateMenuItem((JMenuItem)comp);
                }
                this.updateMenuElements(elements[i].getSubElements());
                ++i;
            }
        }
    }

    protected void updateMenuItem(JMenuItem item) {
        Integer intID;
        Action action = item.getAction();
        if (action != null && (intID = (Integer)action.getValue(ACTION_ID)) != null) {
            int id = intID;
            boolean on = this.dataReaderCount > 0 && GDTUtil.contains(GDTConstants.CHANGE_ACTIONS, id) ? false : this.isCommandValid(id);
            action.setEnabled(on);
        }
    }

    protected void train() {
        if (!this.classifier.isTrained()) {
            ++this.dataReaderCount;
            this.trainingInProgress = true;
            this.updateMenuItem(this.trainMenuItem);
            this.updateInputArea();
            this.summaryLog.append("Training the recognizer... ");
            final JButton stopButton = this.summaryLog.appendButton("Stop", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.trainingWorker.interrupt();
                }
            });
            stopButton.setEnabled(true);
            this.summaryLog.append("\n");
            this.trainingWorker = new SwingWorker(){

                public Object construct() {
                    try {
                        MainFrame.this.classifier.train();
                    }
                    catch (TrainingException e) {
                        return e;
                    }
                    catch (InterruptedException e) {
                        return e;
                    }
                    catch (Exception e) {
                        System.err.println("WARNING: an unexpected exception occurred: " + e);
                        e.printStackTrace();
                        return e;
                    }
                    return null;
                }

                public void finished() {
                    stopButton.setEnabled(false);
                    Object result = this.getValue();
                    if (result == null) {
                        MainFrame.this.message("Training succeeded");
                    } else if (result instanceof InterruptedException) {
                        MainFrame.this.message("Training stopped");
                    } else {
                        MainFrame.this.message("Training failed: " + result.toString());
                        if (!(result instanceof TrainingException)) {
                            MainFrame.this.showErrorDialog("Training failed", "Training failed", (Exception)result);
                        }
                    }
                    MainFrame.this.trainingInProgress = false;
                    --MainFrame.this.dataReaderCount;
                    MainFrame.this.updateMenuBar();
                    MainFrame.this.updateInputArea();
                }
            };
            this.trainingWorker.start();
        }
    }

    public void recognizeGesture(final Gesture gesture) {
        if (this.recognizedCategory != null) {
            this.recognizedCategory.unsetProperty("correctly recognized");
            this.recognizedCategory = null;
        }
        this.train();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                Object trainingResult;
                if (MainFrame.this.trainingWorker != null && (trainingResult = MainFrame.this.trainingWorker.get()) instanceof Exception) {
                    return trainingResult;
                }
                return MainFrame.this.classifier.classifyWithoutTraining(gesture);
            }

            public void finished() {
                Object result = this.getValue();
                if (result instanceof InterruptedException) {
                    MainFrame.this.message("Recognition was stopped");
                } else if (result instanceof TrainingException) {
                    MainFrame.this.showErrorDialog("Training failed", "Could not train recognizer.  Try adding more gestures or more gesture categories.", (Exception)result);
                } else if (result instanceof Exception) {
                    MainFrame.this.message("Recognition failed: " + result.toString());
                    MainFrame.this.showErrorDialog("Recognition failed", "Recognition failed", (Exception)result);
                } else if (result == null || ((Classifier.Result)result).category == null) {
                    MainFrame.this.message("No match");
                } else {
                    Classifier.Result r = (Classifier.Result)result;
                    String catName = r.category.getName();
                    MainFrame.this.message("Recognized as: " + catName + "\t" + Misc.toString(r.accuracy, 3) + "\t" + Misc.toString(r.distToMean, 3));
                    r.category.setProperty("correctly recognized", r);
                    MainFrame.this.recognizedCategory = r.category;
                }
                --MainFrame.this.dataReaderCount;
                MainFrame.this.updateMenuBar();
            }
        };
        ++this.dataReaderCount;
        this.updateMenuBar();
        worker.start();
    }

    private void testRecognition() {
        if (!this.classifier.isTrained()) {
            this.summaryLog.append("Need to train before testing recognition. ");
            this.train();
        }
        final Iterator selectionIterator = this.currentSelection.iterator();
        final JButton stopButton = new JButton("Stop");
        stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.testWorker.interrupt();
            }
        });
        stopButton.setMargin(new Insets(0, 2, 0, 2));
        this.testWorker = new SwingWorker(){

            public Object construct() {
                Object trainingResult;
                if (MainFrame.this.trainingWorker != null && (trainingResult = MainFrame.this.trainingWorker.get()) instanceof Exception) {
                    return trainingResult;
                }
                SwingUtilities.invokeLater(new Runnable(this, stopButton){
                    final /* synthetic */ 21 this$1;
                    private final /* synthetic */ JButton val$stopButton;
                    {
                        this.this$1 = var1_1;
                        this.val$stopButton = jButton;
                    }

                    public void run() {
                        21.access$0(this.this$1).summaryLog.append("Testing recognition... ");
                        21.access$0(this.this$1).summaryLog.append(this.val$stopButton);
                        21.access$0(this.this$1).summaryLog.append("\n");
                    }
                });
                List misrecogGestures = null;
                try {
                    misrecogGestures = MainFrame.this.classifier.testRecognition(selectionIterator);
                }
                catch (TrainingException e) {
                    return e;
                }
                catch (InterruptedException e) {
                    return e;
                }
                catch (Exception e) {
                    System.err.println("WARNING: unexpected exception: " + e);
                    e.printStackTrace();
                    return e;
                }
                return misrecogGestures;
            }

            public void finished() {
                stopButton.setEnabled(false);
                Object result = this.getValue();
                if (result instanceof List) {
                    List misrecogGestures = (List)result;
                    int misrecogCount = misrecogGestures.size();
                    MainFrame.this.summaryLog.append("Recognition tested.");
                    if (misrecogCount > 0) {
                        MainFrame.this.summaryLog.append("\n");
                        MisrecognitionNotice notice = new MisrecognitionNotice(MainFrame.this, misrecogGestures);
                        notice.displaySummary(MainFrame.this.summaryLog);
                    } else {
                        MainFrame.this.summaryLog.append(" All gestures recognized correctly.\n");
                    }
                } else if (result instanceof InterruptedException) {
                    MainFrame.this.message("Recognition testing stopped");
                } else {
                    MainFrame.this.message("Recognition testing failed: " + result.toString());
                    MainFrame.this.showErrorDialog("Recognition testing failed", "Recognition testing failed", (Exception)result);
                }
                --MainFrame.this.dataReaderCount;
                MainFrame.this.updateMenuItem(MainFrame.this.testMenuItem);
                MainFrame.this.updateInputArea();
            }

            static /* synthetic */ MainFrame access$0(21 var0) {
                return var0.MainFrame.this;
            }
        };
        ++this.dataReaderCount;
        this.testWorker.start();
    }

    protected void showAboutBox() {
        JLabel label = new JLabel("quill: Created by A. Chris Long");
        JOptionPane.showMessageDialog(this, label, "quill: About", 1);
    }

    public void moreBusy() {
        ++this.busyCount;
        if (this.busyCount == 1) {
            Component glassPane = this.getGlassPane();
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        }
    }

    public void lessBusy() {
        if (this.busyCount == 0) {
            System.err.println("WARNING: BOGOSITY: lessBusy() called when system is not busy");
            debug.printStackTrace(System.err);
        } else {
            --this.busyCount;
            if (this.busyCount == 0) {
                Component glassPane = this.getGlassPane();
                glassPane.setCursor(Cursor.getPredefinedCursor(0));
                glassPane.setVisible(false);
            }
        }
    }

    public void doLongTask(final Runnable runnable) {
        this.moreBusy();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    MainFrame.this.lessBusy();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    MainFrame.this.lessBusy();
                    return;
                }
            }
        });
    }

    public void setLogBackground(final Color c) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.getSummaryLog().setTextBackground(c);
            }
        });
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (Properties.isPropertyPersistent((e = Properties.getRootEvent(e)).getPropertyName())) {
                MainFrame.this.packageChanged();
            }
        }
    }

    protected class MyCollectionListener
    implements CollectionListener {
        protected MyCollectionListener() {
        }

        public void elementAdded(CollectionEvent e) {
            System.out.println("add");
            MainFrame.this.packageChanged();
        }

        public void elementRemoved(CollectionEvent e) {
            System.out.println("remove");
            MainFrame.this.packageChanged();
        }

        public void elementChanged(CollectionEvent e) {
            System.out.println("change");
            MainFrame.this.packageChanged();
        }
    }
}

