/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.apps.gdt.HowToPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;

public class HowToManager {
    protected static final String HOW_TO_FRAME_PROP = "HOW_TO_FRAME";
    protected static HowToManager defaultManager = new HowToManager();
    protected JButton closeButton;

    protected HowToManager() {
    }

    public static HowToManager getManager() {
        return defaultManager;
    }

    public void showHowTo(MainFrame mainFrame, Notice notice) {
        JFrame frame = (JFrame)mainFrame.getRootPane().getClientProperty(HOW_TO_FRAME_PROP);
        if (frame == null) {
            frame = this.createFrame(mainFrame, notice);
            mainFrame.getRootPane().putClientProperty(HOW_TO_FRAME_PROP, frame);
        }
        this.setNotice(mainFrame, frame, notice);
        frame.pack();
        frame.setVisible(true);
        frame.toFront();
    }

    protected JFrame createFrame(MainFrame mainFrame, Notice notice) {
        HowToPanel htPanel = notice.getHowToPanel();
        htPanel.setMainFrame(mainFrame);
        final JFrame frame = new JFrame();
        Container contents = frame.getContentPane();
        contents.setLayout(new BorderLayout());
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
            }
        });
        return frame;
    }

    protected void setNotice(MainFrame mainFrame, JFrame frame, Notice notice) {
        String title = String.valueOf(mainFrame.getGesturePackage().getName()) + " - " + "How To - " + notice.getName() + " - quill";
        frame.setTitle(title);
        Container contents = frame.getContentPane();
        HowToPanel htPanel = notice.getHowToPanel();
        contents.removeAll();
        contents.add((Component)this.closeButton, "South");
        contents.add((Component)htPanel, "Center");
    }
}

