/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.util.CollectionAdapter;
import edu.berkeley.guir.lib.gesture.util.CollectionEvent;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class GestureTreeModel
extends DefaultTreeModel {
    protected EventListenerList modelListenerList = new EventListenerList();
    protected GesturePackage gesturePackage;
    protected GestureTreeNode testRootNode;
    protected GestureTreeNode trainingRootNode;

    public GestureTreeModel(GesturePackage gPackage) {
        super(new DefaultMutableTreeNode(), true);
        this.gesturePackage = gPackage;
        this.setRoot(this.buildTree(gPackage));
    }

    public TreeNode getTestRootNode() {
        return this.testRootNode;
    }

    public TreeNode getTrainingRootNode() {
        return this.trainingRootNode;
    }

    public GesturePackage getGesturePackage() {
        return this.gesturePackage;
    }

    protected GestureTreeNode buildTree(GesturePackage gesturePackage) {
        GestureTreeNode rootNode = this.buildTree((GestureObject)gesturePackage);
        this.trainingRootNode = (GestureTreeNode)rootNode.getChildAt(0);
        this.testRootNode = (GestureTreeNode)rootNode.getChildAt(1);
        return rootNode;
    }

    protected GestureTreeNode buildTree(GestureObject gestureObject) {
        GestureTreeNode node = this.makeTreeNode(gestureObject);
        if (node.getAllowsChildren()) {
            this.addChildren((GestureContainer)gestureObject, node);
        }
        return node;
    }

    protected GestureTreeNode addChildren(GestureContainer gestureContainer, GestureTreeNode root) {
        Iterator iter = gestureContainer.iterator();
        while (iter.hasNext()) {
            GestureObject gestureObj = (GestureObject)iter.next();
            if (!(gestureObj instanceof GestureContainer)) continue;
            GestureTreeNode node = this.buildTree(gestureObj);
            root.add(node);
        }
        return root;
    }

    protected GestureTreeNode makeTreeNode(GestureObject userObj) {
        return this.makeTreeNode(userObj, !(userObj instanceof GestureObject) || userObj instanceof GestureContainer && !(userObj instanceof GestureCategory));
    }

    protected GestureTreeNode makeTreeNode(GestureObject userObj, boolean allowsChildren) {
        GestureTreeNode result = userObj instanceof Gesture ? new GestureTreeNode(userObj, allowsChildren){

            public String toString() {
                return "example";
            }
        } : new GestureTreeNode(userObj, allowsChildren);
        return result;
    }

    public void insertObjects(TreeNode treeNode, int startIndex, GestureObject[] newObjs) {
        this.insertObjects(treeNode, startIndex, Arrays.asList(newObjs));
    }

    public void insertObjects(TreeNode treeNode, int startIndex, List gestureObjects) {
        GestureTreeNode parentNode = (GestureTreeNode)treeNode;
        if (startIndex == -1) {
            startIndex = parentNode.getChildCount();
        }
        int i = 0;
        Iterator iter = gestureObjects.iterator();
        while (iter.hasNext()) {
            GestureObject newObj = (GestureObject)iter.next();
            GestureTreeNode childNode = this.makeTreeNode(newObj);
            this.insertNodeInto(childNode, parentNode, startIndex + i);
            if (newObj instanceof GestureContainer && !(newObj instanceof GestureCategory)) {
                GestureContainer container = (GestureContainer)newObj;
                this.insertObjects((TreeNode)childNode, 0, AbstractGestureContainer.getChildList(container));
            }
            ++i;
        }
    }

    public void printChildren(GestureTreeNode node) {
        System.out.println("children for " + node + ":");
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            System.out.println("\t" + en.nextElement());
        }
    }

    public void removeObjects(TreeNode treeNode, int startIndex, int count) {
        GestureTreeNode parent = (GestureTreeNode)treeNode;
        int i = count - 1;
        while (i >= 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(startIndex + i);
            this.removeNodeFromParent(child);
            --i;
        }
    }

    public boolean isNodeRenamable(TreeNode node) {
        return node != this.getRoot() && node != this.getTrainingRootNode() && node != this.getTestRootNode();
    }

    protected class GestureTreeNode
    extends DefaultMutableTreeNode {
        protected PropertyChangeListener propChangeListener;
        protected CollectionListener collectionListener;

        public GestureTreeNode() {
            super(null);
            this.propChangeListener = new PropertyChangeListener(this){
                final /* synthetic */ GestureTreeNode this$1;
                {
                    this.this$1 = gestureTreeNode;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    GestureTreeNode.access$0(this.this$1).nodeChanged(this.this$1);
                }
            };
            this.collectionListener = new CollectionAdapter(this){
                final /* synthetic */ GestureTreeNode this$1;
                {
                    this.this$1 = gestureTreeNode;
                }

                public void elementAdded(CollectionEvent e) {
                    GestureObject[] newObjs = (GestureObject[])e.getElements();
                    GestureTreeNode.access$0(this.this$1).insertObjects((TreeNode)this.this$1, e.getStartIndex(), newObjs);
                }

                public void elementRemoved(CollectionEvent e) {
                    GestureTreeNode.access$0(this.this$1).removeObjects(this.this$1, e.getStartIndex(), e.getElementCount());
                }
            };
        }

        public GestureTreeNode(GestureObject obj) {
            this(obj, true);
        }

        public GestureTreeNode(GestureObject obj, boolean allowsChildren) {
            super(null, allowsChildren);
            this.propChangeListener = new /* invalid duplicate definition of identical inner class */;
            this.collectionListener = new /* invalid duplicate definition of identical inner class */;
            this.setUserObject(obj);
        }

        public void setUserObject(Object userObject) {
            Object oldUserObject = this.getUserObject();
            if (oldUserObject != null && oldUserObject instanceof GestureObject) {
                this.unsetListeners((GestureObject)oldUserObject);
            }
            super.setUserObject(userObject);
            if (userObject != null && userObject instanceof GestureObject) {
                this.setListeners((GestureObject)userObject);
            }
        }

        protected void unsetListeners(GestureObject obj) {
            obj.removePropertyChangeListener(this.propChangeListener);
            if (obj instanceof GestureContainer && !(obj instanceof GestureCategory)) {
                GestureContainer container = (GestureContainer)obj;
                container.removeCollectionListener(this.collectionListener);
            }
        }

        protected void setListeners(GestureObject obj) {
            obj.addPropertyChangeListener(this.propChangeListener);
            if (obj instanceof GestureContainer && !(obj instanceof GestureCategory)) {
                GestureContainer container = (GestureContainer)obj;
                container.addCollectionListener(this.collectionListener);
            }
        }

        public String toString() {
            Object userObj = this.getUserObject();
            if (userObj instanceof GestureContainer) {
                return ((GestureContainer)userObj).getName();
            }
            return userObj.toString();
        }

        static /* synthetic */ GestureTreeModel access$0(GestureTreeNode gestureTreeNode) {
            return gestureTreeNode.GestureTreeModel.this;
        }
    }
}

