/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureGroup;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GestureTestSet;
import edu.berkeley.guir.lib.gesture.apps.gdt.CommandUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.Commander;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTClipboard;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureAcceptor;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureFlavorFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTransferable;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTreeModel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import edu.berkeley.guir.lib.gesture.apps.gdt.NoticeHandler;
import edu.berkeley.guir.lib.gesture.util.CompositeIcon;
import edu.berkeley.guir.lib.gesture.util.Gensym;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GestureTree
extends JTree
implements Commander,
GestureAcceptor,
GDTConstants,
ClipboardOwner {
    protected EventListenerList listenerList = new EventListenerList();
    GestureContainer editValue = null;
    protected Classifier classifier = null;
    protected GestureAcceptor addAcceptor = new AddAcceptor();
    protected GestureAcceptor replaceAcceptor = new ReplaceAcceptor();
    protected GestureAcceptor recognizeAcceptor = new RecognizeAcceptor();
    private JTextField textEditWidget = new JTextField();
    protected static Icon LEAF_ICON;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.GestureTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LEAF_ICON = new ImageIcon(clazz.getResource("images/gesture.bm"));
    }

    public GestureTree() {
        super((TreeModel)null);
        this.setToggleClickCount(0);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        GestureTreeCellRenderer renderer = new GestureTreeCellRenderer();
        this.setCellRenderer(renderer);
        this.setCellEditor(new DefaultTreeCellEditor(this, renderer, new GestureCellEditor()));
        this.addMouseListener(new MyMouseListener());
    }

    protected MainFrame getMainFrame() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MainFrame mf = (MainFrame)SwingUtilities.getAncestorOfClass(clazz, this);
        return mf;
    }

    public void setModel(TreeModel model) {
        if (model != null && !(model instanceof GestureTreeModel)) {
            throw new IllegalArgumentException("Only GestureTreeModel is allowed, not " + model.getClass().getName() + " (" + model + ")");
        }
        super.setModel(model);
    }

    public boolean isPathEditable(TreePath path) {
        GestureTreeModel model = (GestureTreeModel)this.getModel();
        return model.isNodeRenamable((TreeNode)path.getLastPathComponent());
    }

    public static Object getUserObject(Object obj) {
        return ((DefaultMutableTreeNode)obj).getUserObject();
    }

    public boolean isCommandValid(int id) {
        boolean valid;
        switch (id) {
            case 201: 
            case 202: 
            case 204: {
                int[] selectedRows = this.getSelectionRows();
                valid = false;
                if (selectedRows == null) break;
                int i = 0;
                while (i < selectedRows.length && !valid) {
                    if (selectedRows[i] != 0) {
                        valid = true;
                    }
                    ++i;
                }
                break;
            }
            case 203: {
                Transferable transferable = GDTClipboard.getClipboard().getContents(this);
                valid = transferable != null && this.canPaste(transferable);
                break;
            }
            case 401: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.GestureCategory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                valid = this.canAdd(clazz);
                break;
            }
            case 402: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.GestureGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                valid = this.canAdd(clazz);
                break;
            }
            case 403: {
                valid = this.getSelectionCount() == 1 && this.isPathEditable(this.getSelectionPath());
                break;
            }
            case 404: {
                valid = !this.isSelectionEmpty();
                break;
            }
            case 408: {
                valid = !this.isSelectionEmpty();
                break;
            }
            case 407: {
                valid = this.getSelectionCount() == 1 && this.getSelectedObject() instanceof GestureTestSet;
            }
            default: {
                valid = false;
            }
        }
        return valid;
    }

    protected boolean canAdd(Class c) {
        TreePath path;
        boolean valid = this.getSelectionCount() == 1 ? this.findParent(c, path = this.getSelectionPath()) != null : false;
        return valid;
    }

    protected Object getLeafUserObject(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node.getUserObject();
    }

    protected DefaultMutableTreeNode findParent(Class c, TreePath path) {
        DefaultMutableTreeNode result = null;
        while (path != null && result == null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObj = node.getUserObject();
            if (userObj instanceof GestureContainer && ((GestureContainer)userObj).isChildType(c)) {
                result = node;
                continue;
            }
            path = path.getParentPath();
        }
        return result;
    }

    public Object getSelectedObject() {
        TreePath[] selectedPaths = this.getSelectionPaths();
        return ((DefaultMutableTreeNode)selectedPaths[0].getLastPathComponent()).getUserObject();
    }

    public List getSelectedObjects() {
        List selection;
        TreePath[] selectedPaths = this.getSelectionPaths();
        if (selectedPaths == null) {
            selection = null;
        } else {
            List<TreePath> list = Arrays.asList(selectedPaths);
            selection = (List)Misc.mapcar(list, new Misc.UnaryOperator(){

                public Object operate(Object obj) {
                    TreePath p = (TreePath)obj;
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getLastPathComponent();
                    return n.getUserObject();
                }
            });
        }
        return selection;
    }

    protected boolean canPaste(Transferable t) {
        return this.getPasteTarget(t) != null;
    }

    protected GestureContainer getPasteTarget(Transferable t) {
        Object selectedObj;
        GestureContainer target = null;
        if (t instanceof GestureTransferable && this.getSelectionCount() == 1 && (selectedObj = this.getSelectedObject()) instanceof GestureContainer) {
            GestureTransferable gt = (GestureTransferable)t;
            if (this.canPaste(gt, (GestureContainer)selectedObj)) {
                target = (GestureContainer)selectedObj;
            } else {
                DefaultMutableTreeNode parentNode;
                GestureContainer parent;
                TreePath selectionPath = this.getSelectionPath();
                TreePath parentPath = selectionPath.getParentPath();
                if (parentPath != null && this.canPaste(gt, parent = (GestureContainer)(parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject())) {
                    target = parent;
                }
            }
        }
        return target;
    }

    protected boolean canPaste(GestureTransferable t, GestureContainer container) {
        boolean result = false;
        Class[] childTypes = container.getChildTypes();
        int i = 0;
        while (i < childTypes.length && !result) {
            if (t.isClassSupported(childTypes[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void doCommand(int id) {
        switch (id) {
            case 201: {
                this.doCopy();
                this.doDelete();
                break;
            }
            case 202: {
                this.doCopy();
                break;
            }
            case 204: {
                this.doDelete();
                break;
            }
            case 203: {
                this.doPaste();
                break;
            }
            case 401: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.GestureCategory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DefaultMutableTreeNode node = this.findParent(clazz, this.getSelectionPath());
                GestureContainer container = (GestureContainer)node.getUserObject();
                container.add(new GestureCategory(Gensym.next("gesture")));
                break;
            }
            case 402: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.GestureGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DefaultMutableTreeNode node = this.findParent(clazz, this.getSelectionPath());
                GestureContainer container = (GestureContainer)node.getUserObject();
                container.add(new GestureGroup(Gensym.next("group")));
                break;
            }
            case 403: {
                this.startEditingAtPath(this.getSelectionPath());
                break;
            }
            case 404: {
                GDTUtil.setProperty(this.getSelectedObjects(), "enabled", new Boolean(true));
                break;
            }
            case 408: {
                GDTUtil.setProperty(this.getSelectedObjects(), "enabled", new Boolean(false));
                break;
            }
            case 407: {
                System.out.println("Not yet implemented");
                break;
            }
            default: {
                System.err.println("GestureTree: cannot perform action " + id);
            }
        }
    }

    protected List getTopLevelSelectionPaths() {
        ArrayList<TreePath> result;
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            result = new ArrayList<TreePath>();
            int i = 0;
            while (i < selectionPaths.length) {
                boolean isDescendant = false;
                Iterator iter = result.iterator();
                while (iter.hasNext()) {
                    TreePath oldPath = (TreePath)iter.next();
                    if (oldPath.isDescendant(selectionPaths[i])) {
                        isDescendant = true;
                        continue;
                    }
                    if (!selectionPaths[i].isDescendant(oldPath)) continue;
                    iter.remove();
                }
                if (!isDescendant) {
                    result.add(selectionPaths[i]);
                }
                ++i;
            }
        } else {
            result = null;
        }
        return result;
    }

    public void doCopy() {
        List selectedObjects = this.getSelectedObjects();
        GDTClipboard clipboard = GDTClipboard.getClipboard();
        GestureTransferable transferable = new GestureTransferable(selectedObjects);
        clipboard.setContents(transferable, this);
        CommandUtil.fireMenuValidChangeEvent(this.listenerList, new ChangeEvent(this));
    }

    public void doPaste() {
        Transferable transferable = GDTClipboard.getClipboard().getContents(this);
        GestureContainer target = this.getPasteTarget(transferable);
        if (transferable.isDataFlavorSupported(GestureFlavorFactory.GESTURE_OBJECT_FLAVOR)) {
            try {
                GestureObject obj = (GestureObject)transferable.getTransferData(GestureFlavorFactory.GESTURE_OBJECT_FLAVOR);
                target.add(obj);
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("Transferable claimed it supported GESTURE_OBJECT_FLAVOR but it lied");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not paste due to I/O error.", "Paste failed", 0);
            }
        } else if (transferable.isDataFlavorSupported(GestureFlavorFactory.GESTURE_OBJECT_COLLECTION_FLAVOR)) {
            try {
                Collection collection = (Collection)transferable.getTransferData(GestureFlavorFactory.GESTURE_OBJECT_COLLECTION_FLAVOR);
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    GestureObject obj = (GestureObject)iter.next();
                    target.add((GestureObject)obj.clone());
                }
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("Transferable claimed it supported GESTURE_COLLECTION_OBJECT_FLAVOR but it lied");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not paste due to I/O error.", "Paste failed", 0);
            }
        } else {
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            System.err.println("ERROR: bad transferable: " + flavors[0].getHumanPresentableName());
        }
    }

    public void doDelete() {
        List selectionPaths = this.getTopLevelSelectionPaths();
        Iterator iter = selectionPaths.iterator();
        while (iter.hasNext()) {
            TreePath path = (TreePath)iter.next();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (parentNode == null) continue;
            GestureObject userObj = (GestureObject)node.getUserObject();
            GestureContainer container = (GestureContainer)parentNode.getUserObject();
            container.remove(userObj);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    public boolean canAcceptGesture() {
        return this.getSelectionCount() > 0;
    }

    protected GestureAcceptor getGestureAcceptor() {
        GestureObject selection;
        GestureAcceptor result = this.getSelectionCount() == 1 ? ((selection = (GestureObject)this.getSelectedObject()) instanceof GestureCategory ? this.addAcceptor : (selection instanceof Gesture ? this.replaceAcceptor : this.recognizeAcceptor)) : (this.getSelectionCount() > 1 ? this.recognizeAcceptor : null);
        return result;
    }

    public String getInputGestureTitle() {
        return this.getGestureAcceptor().getInputGestureTitle();
    }

    public boolean gestureDrawn(Gesture gesture) {
        return this.getGestureAcceptor().gestureDrawn(gesture);
    }

    protected boolean isWarningHit(TreePath path, int x) {
        GestureObject gestureObj;
        boolean result = false;
        Object userObj = this.getLeafUserObject(path);
        if (userObj instanceof GestureObject && NoticeHandler.hasNoticesInTree(gestureObj = (GestureObject)userObj)) {
            Rectangle bounds = this.getPathBounds(path);
            int delta = x - bounds.x;
            result = delta > 16 && delta < 32;
        }
        return result;
    }

    protected Notice getFirstNotice(GestureObject gestureObj) {
        Notice result = null;
        if (NoticeHandler.hasNotices(gestureObj)) {
            List notices = (List)gestureObj.getProperty("notice list");
            result = (Notice)notices.get(0);
        } else if (NoticeHandler.hasNoticesInTree(gestureObj)) {
            List objs = (List)gestureObj.getProperty("notice descendents");
            GestureObject obj = (GestureObject)objs.get(0);
            result = this.getFirstNotice(obj);
        }
        return result;
    }

    class GestureCellEditor
    extends DefaultCellEditor {
        public GestureCellEditor() {
            super(GestureTree.this.textEditWidget);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
            this.delegate.setValue(stringValue);
            GestureTree.this.editValue = (GestureContainer)GestureTree.getUserObject(value);
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            String stringValue = (String)this.delegate.getCellEditorValue();
            GestureTree.this.editValue.setName(stringValue);
            return GestureTree.this.editValue;
        }
    }

    protected class GestureTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Font ENABLED_FONT = UIManager.getFont("Tree.font");
        public Font DISABLED_FONT = this.ENABLED_FONT.deriveFont(2);
        public Color RECOG_COLOR = Color.green.darker();
        public Color NON_RECOG_COLOR = Color.black;

        public GestureTreeCellRenderer() {
            this.setLeafIcon(LEAF_ICON);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object userObj;
            Component result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            boolean isEnabled = true;
            boolean isRecognized = false;
            if (value instanceof DefaultMutableTreeNode && (userObj = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof GestureObject) {
                GestureObject gestureObj = (GestureObject)userObj;
                isEnabled = gestureObj.isEnabled();
                if (userObj instanceof GestureContainer && ((GestureContainer)userObj).hasProperty("correctly recognized")) {
                    isRecognized = true;
                }
                if (NoticeHandler.hasNoticesInTree(gestureObj) && GestureTree.this.getMainFrame().areNoticesVisible()) {
                    JLabel label = (JLabel)result;
                    Icon oldIcon = label.getIcon();
                    if (oldIcon == null) {
                        label.setIcon(NoticeHandler.NOTICE_ICON);
                    } else {
                        CompositeIcon newIcon = new CompositeIcon();
                        newIcon.add(oldIcon);
                        newIcon.add(NoticeHandler.NOTICE_ICON);
                        label.setIcon(newIcon);
                    }
                }
            }
            result.setForeground(isRecognized ? this.RECOG_COLOR : this.NON_RECOG_COLOR);
            result.setFont(isEnabled ? this.ENABLED_FONT : this.DISABLED_FONT);
            return result;
        }
    }

    protected class MyMouseListener
    extends MouseAdapter {
        protected MyMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TreePath selectedPath = GestureTree.this.getPathForLocation(e.getX(), e.getY());
            if (selectedPath != null && GestureTree.this.getMainFrame().areNoticesVisible() && GestureTree.this.isWarningHit(selectedPath, e.getX())) {
                GestureObject gestureObj = (GestureObject)GestureTree.this.getLeafUserObject(selectedPath);
                Notice firstNotice = GestureTree.this.getFirstNotice(gestureObj);
                int position = firstNotice.getPosition().getOffset();
                JTextPane textPane = GestureTree.this.getMainFrame().getSummaryLog().getTextPane();
                try {
                    Rectangle rect = textPane.modelToView(position);
                    textPane.scrollRectToVisible(rect);
                }
                catch (BadLocationException exception) {
                    System.err.println("WARNING: can't find the notice: " + firstNotice);
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                if (selectedPath != null) {
                    GestureTree.this.startEditingAtPath(selectedPath);
                }
            } else if (e.getClickCount() == 2) {
                GestureTree.this.getMainFrame().showPath(selectedPath);
            }
        }
    }

    protected class AddAcceptor
    implements GestureAcceptor {
        protected AddAcceptor() {
        }

        public boolean canAcceptGesture() {
            return GestureTree.this.getSelectionCount() == 1 && GestureTree.this.getSelectedObject() instanceof GestureCategory;
        }

        public String getInputGestureTitle() {
            return "Draw a gesture to add to the category";
        }

        public boolean gestureDrawn(Gesture g) {
            GestureCategory category = (GestureCategory)GestureTree.this.getSelectedObject();
            g.normalize();
            category.add(g);
            return true;
        }
    }

    protected class ReplaceAcceptor
    implements GestureAcceptor {
        protected ReplaceAcceptor() {
        }

        public boolean canAcceptGesture() {
            return GestureTree.this.getSelectionCount() == 1 && GestureTree.this.getSelectedObject() instanceof Gesture;
        }

        public String getInputGestureTitle() {
            return "Draw a replacement gesture";
        }

        public boolean gestureDrawn(Gesture g) {
            Gesture selectedGesture = (Gesture)GestureTree.this.getSelectedObject();
            g.normalize();
            selectedGesture.setPoints(g.getPoints());
            return true;
        }
    }

    protected class RecognizeAcceptor
    implements GestureAcceptor {
        protected RecognizeAcceptor() {
        }

        public boolean canAcceptGesture() {
            return true;
        }

        public String getInputGestureTitle() {
            return "Draw a gesture to be recognized";
        }

        public boolean gestureDrawn(Gesture g) {
            GestureTree.this.getMainFrame().recognizeGesture(g);
            return false;
        }
    }
}

