/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureFlavorFactory;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;

public class GestureTransferable
implements Transferable {
    private Object data;
    private DataFlavor flavor;
    protected static final Class[] CLASS_ORDER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.Gesture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.GestureCategory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.GestureGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.GestureSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        CLASS_ORDER = classArray;
    }

    public GestureTransferable(GestureObject gestureObj) {
        this.data = gestureObj;
        this.flavor = GestureFlavorFactory.getDataFlavor(gestureObj.getClass());
    }

    public GestureTransferable(Collection collection) {
        this.data = collection;
        Class biggestClass = GestureTransferable.getBiggestElementClass(collection);
        this.flavor = GestureFlavorFactory.getCollectionDataFlavor(biggestClass);
        if (this.flavor == null) {
            System.err.println("ERROR: can't find a flavor for " + biggestClass);
        }
    }

    public static Class getBiggestElementClass(Collection collection) {
        Object obj = Misc.findLargest(collection, new Comparator(){

            public int compare(Object a, Object b) {
                return GestureTransferable.compareGestureTypes(a.getClass(), b.getClass());
            }
        });
        return obj.getClass();
    }

    protected static int compareGestureTypes(Class a, Class b) {
        int indexB;
        int indexA = Misc.indexOf(CLASS_ORDER, a);
        return indexA == (indexB = Misc.indexOf(CLASS_ORDER, b)) ? 0 : (indexA < indexB ? -1 : 1);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor genericFlavor = this.data instanceof Collection ? GestureFlavorFactory.GESTURE_OBJECT_COLLECTION_FLAVOR : GestureFlavorFactory.GESTURE_OBJECT_FLAVOR;
        DataFlavor[] result = new DataFlavor[]{this.flavor, genericFlavor};
        return result;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        Object[] flavors = this.getTransferDataFlavors();
        return Misc.indexOf(flavors, flavor) != -1;
    }

    public boolean isClassSupported(Class c) {
        return this.isDataFlavorSupported(GestureFlavorFactory.getDataFlavor(c)) || this.isDataFlavorSupported(GestureFlavorFactory.getCollectionDataFlavor(c));
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

