/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePointsDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.EnableListener;
import edu.berkeley.guir.lib.gesture.apps.gdt.FeatureNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureDesktop;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.NoticeHandler;
import edu.berkeley.guir.lib.gesture.apps.gdt.SimpleGestureObjectPanel;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class GestureObjectPanel
extends SimpleGestureObjectPanel {
    protected static Icon INFO_ICON;
    protected PropertyChangeListener propChangeListener = new MyPropChangeListener();
    protected EventListenerList listenerList = new EventListenerList();
    protected InfoActionListener infoActionListener;
    protected JButton misrecogButton = new JButton();
    protected GesturePointsDisplay pointsDisplay;
    protected Classifier.Result misrecogResult = null;
    protected JPanel misrecogPanel;
    protected JPanel outlierPanel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.GestureTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INFO_ICON = new ImageIcon(clazz.getResource("images/graphics-repository/toolbarButtonGraphics/general/Information24.gif"));
    }

    public GestureObjectPanel() {
        this((GestureObject)null);
    }

    public GestureObjectPanel(GestureObject object) {
        super(object);
        this.misrecogButton.setForeground(Color.red);
        this.misrecogButton.addActionListener(new MisrecogAction());
        JButton infoButton = new JButton(INFO_ICON);
        infoButton.setMargin(new Insets(1, 1, 1, 1));
        this.infoActionListener = new InfoActionListener();
        infoButton.addActionListener(this.infoActionListener);
        this.misrecogPanel = new JPanel();
        this.misrecogPanel.add(this.misrecogButton);
        this.misrecogPanel.add(infoButton);
        if (object.hasProperty("misrecognized")) {
            this.setMisrecogButton((Classifier.Result)object.getProperty("misrecognized"));
        } else {
            this.setMisrecogButton(null);
        }
        JLabel outlierLabel = new JLabel("Outlier");
        this.outlierPanel = new JPanel();
        this.outlierPanel.add(outlierLabel);
        this.updateOutlierPanel();
        JPanel noticePanel = new JPanel();
        noticePanel.setLayout(new BoxLayout(noticePanel, 1));
        noticePanel.add(this.misrecogPanel);
        noticePanel.add(this.outlierPanel);
        this.add((Component)noticePanel, "South");
    }

    protected void updateOutlierPanel() {
        Set notices;
        GestureObject gestureObject = this.getDisplayedObject();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.OutlyingGestureNotice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.outlierPanel.setVisible((notices = NoticeHandler.getNoticesOfClass(gestureObject, clazz)).size() > 0);
    }

    protected void setMisrecogButton(Classifier.Result result) {
        this.misrecogResult = result;
        if (result == null) {
            this.misrecogPanel.setVisible(false);
        } else {
            String label;
            boolean enabled;
            this.misrecogPanel.setVisible(true);
            if (result.category == null) {
                enabled = false;
                label = "(unrecognized)";
            } else {
                enabled = true;
                label = result.category.getName();
            }
            this.misrecogButton.setEnabled(enabled);
            this.misrecogButton.setText(label);
            this.infoActionListener.setClassification(result);
        }
    }

    protected class InfoActionListener
    implements ActionListener {
        protected Classifier.Result classification = null;
        static /* synthetic */ Class class$0;

        protected InfoActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MainFrame mf = (MainFrame)SwingUtilities.getAncestorOfClass(clazz, GestureObjectPanel.this);
            Classifier classifier = mf.getClassifier();
            Gesture g = (Gesture)GestureObjectPanel.this.getDisplayedObject();
            GestureCategory category = (GestureCategory)g.getParent();
            double[] distByFeature = classifier.getNormalizedDistancesByFeature(g, category.getName());
            int maxDistIndex = Misc.maxAbsIndex(Misc.promoteArray(distByFeature));
            Class[] featureClasses = classifier.getFeatureClasses();
            Feature dummyFeature = null;
            try {
                dummyFeature = (Feature)featureClasses[maxDistIndex].newInstance();
            }
            catch (InstantiationException e) {
                System.err.println("Warning: could not instantiate feature of class '" + featureClasses[maxDistIndex].getName() + "':" + e);
                return;
            }
            catch (IllegalAccessException e) {
                System.err.println("Warning: could not access class '" + featureClasses[maxDistIndex].getName() + "':" + e);
                return;
            }
            mf.getNoticeHandler().showNotice(new FeatureNotice(dummyFeature, GestureObjectPanel.this.getDisplayedObject(), Misc.sign(distByFeature[maxDistIndex])));
        }

        public void setClassification(Classifier.Result r) {
            this.classification = r;
        }
    }

    protected class MisrecogAction
    implements ActionListener {
        static /* synthetic */ Class class$0;

        protected MisrecogAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.GestureDesktop");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            GestureDesktop desktop = (GestureDesktop)SwingUtilities.getAncestorOfClass(clazz, GestureObjectPanel.this);
            desktop.showFrame(GestureObjectPanel.this.misrecogResult.category);
        }
    }

    protected class MyPropChangeListener
    extends EnableListener {
        public MyPropChangeListener() {
            super(GestureObjectPanel.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "misrecognized") {
                Classifier.Result newValue = (Classifier.Result)e.getNewValue();
                GestureObjectPanel.this.setMisrecogButton(newValue);
            } else if (e.getPropertyName() == "notice list") {
                GestureObjectPanel.this.updateOutlierPanel();
            } else {
                super.propertyChange(e);
            }
        }
    }
}

