/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureGroup;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePointsDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.EnableListener;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GestureGroupThumbnailPanel
extends JPanel
implements GestureObjectDisplay,
GDTConstants {
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeListener propChangeListener = new MyPropChangeListener();
    protected GestureGroup group;
    protected JLabel label;
    protected GesturePointsDisplay icon;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GestureGroupThumbnailPanel() {
        this((GestureGroup)null);
    }

    public GestureGroupThumbnailPanel(GestureGroup group) {
        this(group, null);
    }

    public GestureGroupThumbnailPanel(GestureGroup group, JScrollPane scrollPane) {
        super(new BorderLayout());
        this.buildUI();
        this.setGroup(group);
    }

    public void setGroup(GestureGroup group) {
        if (this.group != group) {
            if (this.group != null) {
                this.group.removePropertyChangeListener(this.propChangeListener);
            }
            this.group = group;
            if (group != null) {
                group.addPropertyChangeListener(this.propChangeListener);
            }
            this.updateTitle();
            this.updateIcon();
        }
    }

    public GestureObject getDisplayedObject() {
        return this.group;
    }

    protected void buildUI() {
        this.add((Component)new JLabel("Group:"), "North");
        this.icon = new GesturePointsDisplay();
        this.add((Component)this.icon, "Center");
        this.label = new JLabel();
        this.add((Component)this.label, "South");
        this.updateTitle();
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    protected void updateIcon() {
        GestureCategory cat;
        if (this.group != null && this.group.size() > 0 && (cat = this.group.get(0)) != null && cat.size() > 0) {
            this.icon.setGesture(cat.gestureAt(0));
            this.revalidate();
        }
    }

    protected void updateTitle() {
        String name = this.group == null ? "(no group)" : this.group.getName();
        this.label.setText(name);
        this.repaint();
        this.revalidate();
    }

    public boolean isCommandValid(int id) {
        return false;
    }

    public void doCommand(int id) {
        System.err.println("GestureGroupThumbnailPanel handles no commands (was given id " + id + ")");
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    public String getInputGestureTitle() {
        return "Draw a gesture";
    }

    public boolean gestureDrawn(Gesture g) {
        System.err.println("GestureGroupThumbnailPanel does not accept gestures");
        return false;
    }

    public boolean canAcceptGesture() {
        return false;
    }

    public void setScale(double s) {
    }

    public double getScale() {
        return 1.0;
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected class MyPropChangeListener
    extends EnableListener {
        public MyPropChangeListener() {
            super(GestureGroupThumbnailPanel.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == "name") {
                GestureGroupThumbnailPanel.this.updateTitle();
            } else if (propName == "children" || propName == "child changed") {
                GestureGroupThumbnailPanel.this.updateIcon();
            }
            super.propertyChange(evt);
        }
    }
}

