/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.CommandUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.Commander;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GInternalFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureAcceptor;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureContainerPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GestureDesktop
extends JDesktopPane
implements SwingConstants,
ItemSelectable,
Commander,
GestureAcceptor,
GDTConstants {
    protected EventListenerList listenerList = new EventListenerList();
    private ActionListener myActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            GestureDesktop.this.showFrame(((GestureObjectDisplay)e.getSource()).getDisplayedObject());
        }
    };
    protected InternalFrameListener ifListener = new MyIFListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void showFrame(GestureObject data) {
        this.showFrame(data, data.getParent().getName());
    }

    public void showFrame(GestureObject data, String parentName) {
        GInternalFrame iFrame = GInternalFrame.makeInternalFrame(data, parentName);
        this.showFrame(iFrame);
    }

    public void showFrame(JInternalFrame iFrame) {
        if (iFrame != null) {
            this.add(iFrame);
            iFrame.setVisible(true);
            iFrame.setSize(new Dimension(300, 200));
            iFrame.addInternalFrameListener(this.ifListener);
            if (iFrame instanceof GInternalFrame) {
                GInternalFrame gestureIFrame = (GInternalFrame)iFrame;
                GestureObjectDisplay display = gestureIFrame.getGestureObjectDisplay();
                display.addActionListener(this.myActionListener);
                gestureIFrame.addMenuValidChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        CommandUtil.fireMenuValidChangeEvent(GestureDesktop.this.listenerList, e);
                    }
                });
                if (display instanceof GestureContainerPanel) {
                    ((GestureContainerPanel)display).getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        public void valueChanged(ListSelectionEvent e) {
                            GestureDesktop.this.fireListSelectionEvent(e);
                        }
                    });
                }
            } else {
                iFrame.setClosable(true);
            }
        }
    }

    public boolean gestureDrawn(Gesture g) {
        GestureObjectDisplay display = this.getSelectedGestureObjectDisplay();
        if (display != null && display.canAcceptGesture()) {
            return display.gestureDrawn(g);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MainFrame mf = (MainFrame)SwingUtilities.getAncestorOfClass(clazz, this);
        mf.recognizeGesture(g);
        return false;
    }

    public boolean canAcceptGesture() {
        GestureObjectDisplay display = this.getSelectedGestureObjectDisplay();
        return display != null && display.canAcceptGesture();
    }

    public String getInputGestureTitle() {
        GestureObjectDisplay display = this.getSelectedGestureObjectDisplay();
        if (display != null && display.canAcceptGesture()) {
            return display.getInputGestureTitle();
        }
        return "Draw a gesture to be recognized";
    }

    public GestureObjectDisplay getSelectedGestureObjectDisplay() {
        JInternalFrame selectedFrame = this.getSelectedFrame();
        if (selectedFrame != null && selectedFrame instanceof GInternalFrame) {
            return ((GInternalFrame)selectedFrame).getGestureObjectDisplay();
        }
        return null;
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public Object[] getSelectedObjects() {
        JInternalFrame selection = this.getSelectedFrame();
        if (selection == null) {
            return null;
        }
        Object[] result = new Object[]{selection};
        return result;
    }

    protected void fireItemEvent(JInternalFrame f, int stateChange) {
        ItemEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ItemEvent(this, 701, f, stateChange);
                }
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    public List getSelectedGestureObjects() {
        GestureObjectDisplay display = this.getSelectedGestureObjectDisplay();
        if (display == null || !(display instanceof GestureContainerPanel)) {
            return null;
        }
        GestureContainerPanel containerPanel = (GestureContainerPanel)display;
        return containerPanel.getSelectedGestureObjects();
    }

    public List getSelection() {
        GestureObjectDisplay display = this.getSelectedGestureObjectDisplay();
        if (display == null || !(display instanceof GestureContainerPanel)) {
            return null;
        }
        GestureContainerPanel containerPanel = (GestureContainerPanel)display;
        return containerPanel.getSelectedObjects();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("javax.swing.event.ListSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("javax.swing.event.ListSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    protected void fireListSelectionEvent(ListSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ListSelectionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((ListSelectionListener)listeners[i + 1]).valueChanged(event);
            }
            i -= 2;
        }
    }

    public boolean isCommandValid(int id) {
        JInternalFrame selectedFrame = this.getSelectedFrame();
        boolean valid = selectedFrame != null && selectedFrame instanceof GInternalFrame ? ((GInternalFrame)selectedFrame).isCommandValid(id) : false;
        return valid;
    }

    public void doCommand(int id) {
        JInternalFrame selectedFrame = this.getSelectedFrame();
        if (selectedFrame != null && selectedFrame instanceof GInternalFrame) {
            ((GInternalFrame)selectedFrame).doCommand(id);
        }
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    protected class MyIFListener
    extends InternalFrameAdapter {
        protected MyIFListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            JInternalFrame f = e.getInternalFrame();
            GestureDesktop.this.fireItemEvent(f, 1);
            CommandUtil.fireMenuValidChangeEvent(GestureDesktop.this.listenerList, new ChangeEvent(GestureDesktop.this));
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            JInternalFrame f = e.getInternalFrame();
            GestureDesktop.this.fireItemEvent(f, 2);
            CommandUtil.fireMenuValidChangeEvent(GestureDesktop.this.listenerList, new ChangeEvent(GestureDesktop.this));
        }
    }
}

