/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.HumanCoords;
import edu.berkeley.guir.lib.gesture.apps.gdt.CommandUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.Commander;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.EnableListener;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTClipboard;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureFlavorFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTransferable;
import edu.berkeley.guir.lib.gesture.util.CollectionAdapter;
import edu.berkeley.guir.lib.gesture.util.CollectionEvent;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import edu.berkeley.guir.lib.gesture.util.FlowScrollLayout;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.SelectablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GestureContainerPanel
extends SelectablePanel
implements GestureObjectDisplay,
GDTConstants,
ClipboardOwner {
    protected CollectionListener listener = new MyCollectionListener();
    protected JScrollPane scrollPane;
    private GestureContainer gestureContainer;
    protected EventListenerList listenerList = new EventListenerList();
    private ActionListener forwardingActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            GestureContainerPanel.this.fireActionEvent(e);
        }
    };
    protected PropertyChangeListener propChangeListener = new EnableListener(this);
    protected double scale = 1.0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GestureContainerPanel() {
        this(null, null);
    }

    public GestureContainerPanel(GestureContainer object) {
        this(object, null);
    }

    public GestureContainerPanel(JScrollPane scrollPane) {
        this(null, scrollPane);
    }

    public GestureContainerPanel(GestureContainer object, JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.setGestureContainer(object);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CommandUtil.fireMenuValidChangeEvent(GestureContainerPanel.this.listenerList, new ChangeEvent(GestureContainerPanel.this));
            }
        });
    }

    public void setGestureContainer(GestureContainer object) {
        if (this.gestureContainer != object) {
            if (this.gestureContainer != null) {
                this.gestureContainer.removePropertyChangeListener(this.propChangeListener);
                this.gestureContainer.removeCollectionListener(this.listener);
            }
            this.gestureContainer = object;
            this.buildUI();
            if (this.gestureContainer != null) {
                this.gestureContainer.addCollectionListener(this.listener);
                this.gestureContainer.addPropertyChangeListener(this.propChangeListener);
            }
        }
    }

    public GestureContainer getGestureContainer() {
        return this.gestureContainer;
    }

    public GestureObject getDisplayedObject() {
        return this.gestureContainer;
    }

    protected void buildUI() {
        this.removeAll();
        if (this.gestureContainer != null) {
            FlowScrollLayout layout = new FlowScrollLayout(this.scrollPane, this, true);
            layout.setAlignment(0);
            this.setLayout(layout);
            Iterator iter = this.gestureContainer.iterator();
            while (iter.hasNext()) {
                GestureObject gestureObj = (GestureObject)iter.next();
                this.addGestureObject(gestureObj, this.scrollPane);
            }
            this.setBorder(BorderFactory.createTitledBorder(null, this.gestureContainer.getName(), 2, 0));
        }
    }

    protected void insertGestureObjects(int startIndex, GestureObject[] objs) {
        int i = 0;
        while (i < objs.length) {
            this.addGestureObject(objs[i], this.scrollPane, startIndex + i);
            ++i;
        }
        this.revalidate();
    }

    protected void addGestureObject(GestureObject gestureObj, JScrollPane scrollPane) {
        this.addGestureObject(gestureObj, scrollPane, -1);
    }

    protected void addGestureObject(GestureObject gestureObj, JScrollPane scrollPane, int index) {
        JComponent widget = DisplayFactory.createThumbnail(gestureObj, scrollPane);
        if (widget instanceof SelectablePanel) {
            ((SelectablePanel)widget).setSelectable(false);
        }
        this.add((Component)widget, index);
    }

    protected void removeForwardingListener(int childIndex) {
        Component comp = this.getComponent(childIndex);
        if (comp instanceof GestureObjectDisplay) {
            ((GestureObjectDisplay)((Object)comp)).removeActionListener(this.forwardingActionListener);
        }
    }

    public void remove(int i) {
        this.removeForwardingListener(i);
        super.remove(i);
    }

    public void removeAll() {
        int numComponents = this.getComponentCount();
        int i = 0;
        while (i < numComponents) {
            this.removeForwardingListener(i);
            ++i;
        }
        super.removeAll();
    }

    public void setGestureObject(GestureObject object) {
        if (object != null && !(object instanceof GestureContainer)) {
            throw new IllegalArgumentException("Only GestureCategory is allowed, not " + object.getClass().getName() + " (" + object + ")");
        }
        this.setGestureContainer((GestureContainer)object);
    }

    public String getInputGestureTitle() {
        return "Draw a gesture";
    }

    public boolean gestureDrawn(Gesture g) {
        return false;
    }

    public boolean canAcceptGesture() {
        return false;
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireActionEvent(GestureObjectDisplay display, String command, int modifiers) {
        ActionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ActionEvent(display, 1001, command, modifiers);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(event);
            }
            i -= 2;
        }
    }

    protected void fireActionEvent(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((ActionListener)listeners[i + 1]).actionPerformed(event);
            }
            i -= 2;
        }
    }

    public boolean isCommandValid(int id) {
        boolean valid;
        switch (id) {
            case 201: 
            case 202: 
            case 204: 
            case 0x100002: {
                List selection = this.getSelectedObjects();
                valid = selection.size() > 0;
                break;
            }
            case 203: {
                Transferable transferable = GDTClipboard.getClipboard().getContents(this);
                valid = transferable != null && this.canPaste(transferable);
                break;
            }
            case 404: 
            case 408: {
                valid = true;
                break;
            }
            case 304: 
            case 305: {
                valid = true;
                break;
            }
            case 306: {
                valid = this.scale != 1.0;
                break;
            }
            default: {
                List childCommanders = this.getChildCommanders();
                valid = CommandUtil.isCommandValid(id, childCommanders);
            }
        }
        return valid;
    }

    protected boolean canPaste(Transferable t) {
        return t != null && (t.isDataFlavorSupported(GestureFlavorFactory.GESTURE_OBJECT_FLAVOR) || t.isDataFlavorSupported(GestureFlavorFactory.GESTURE_OBJECT_COLLECTION_FLAVOR));
    }

    public void doCommand(int id) {
        switch (id) {
            case 201: {
                this.doCopy();
                this.doDelete();
                break;
            }
            case 202: {
                this.doCopy();
                break;
            }
            case 204: {
                this.doDelete();
                break;
            }
            case 203: {
                this.doPaste();
                break;
            }
            case 404: {
                List selectedObjs = this.getSelectedGestureObjects();
                if (selectedObjs == null) {
                    this.getDisplayedObject().setEnabled(true);
                } else {
                    GDTUtil.setProperty(selectedObjs, "enabled", new Boolean(true));
                }
                CommandUtil.fireMenuValidChangeEvent(this.listenerList, new ChangeEvent(this));
                break;
            }
            case 408: {
                List selectedObjs = this.getSelectedGestureObjects();
                if (selectedObjs == null) {
                    this.getDisplayedObject().setEnabled(false);
                } else {
                    GDTUtil.setProperty(selectedObjs, "enabled", new Boolean(false));
                }
                CommandUtil.fireMenuValidChangeEvent(this.listenerList, new ChangeEvent(this));
                break;
            }
            case 304: {
                this.setScale(this.scale * 2.0);
                break;
            }
            case 305: {
                this.setScale(this.scale / 2.0);
                break;
            }
            case 306: {
                this.setScale(1.0);
                break;
            }
            case 0x100002: {
                this.doDumpHumanCoords();
                break;
            }
            default: {
                List childCommanders = this.getChildCommanders();
                CommandUtil.doCommand(id, childCommanders);
            }
        }
    }

    protected void doDumpHumanCoords() {
        List selectedObjs = this.getSelectedGestureObjects();
        Iterator iter = selectedObjs.iterator();
        while (iter.hasNext()) {
            GestureObject obj = (GestureObject)iter.next();
            if (obj instanceof GestureCategory) {
                GestureCategory cat = (GestureCategory)obj;
                System.out.println(String.valueOf(cat.getName()) + "\t" + GestureContainerPanel.toString(HumanCoords.averageCoords(cat)));
                continue;
            }
            if (!(obj instanceof Gesture)) continue;
            Gesture gesture = (Gesture)obj;
            GestureCategory cat = (GestureCategory)gesture.getParent();
            System.out.println(String.valueOf(cat.getName()) + " #" + cat.getGestureIndex(gesture) + "\t" + GestureContainerPanel.toString(HumanCoords.computeCoords(gesture)));
        }
    }

    protected static String toString(double[] x) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < x.length) {
            result.append(" ");
            result.append(x[i]);
            ++i;
        }
        return result.toString();
    }

    protected List getChildCommanders() {
        ArrayList<Component> result = new ArrayList<Component>();
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof Commander) {
                result.add(components[i]);
            }
            ++i;
        }
        return result;
    }

    private static String toString(GestureObject g) {
        return g.toString();
    }

    protected List getSelectedGestureObjects() {
        return (List)Misc.mapcar(this.getSelectedObjects(), new Misc.UnaryOperator(){

            public Object operate(Object obj) {
                GestureObject gestureObj = ((GestureObjectDisplay)obj).getDisplayedObject();
                return gestureObj;
            }
        });
    }

    public void doCopy() {
        Collection selectedObjects = Misc.mapcar(this.getSelectedObjects(), new Misc.UnaryOperator(){

            public Object operate(Object obj) {
                GestureObject gestureObj = ((GestureObjectDisplay)obj).getDisplayedObject();
                return gestureObj;
            }
        });
        GDTClipboard clipboard = GDTClipboard.getClipboard();
        GestureTransferable transferable = new GestureTransferable(selectedObjects);
        clipboard.setContents(transferable, this);
        CommandUtil.fireMenuValidChangeEvent(this.listenerList, new ChangeEvent(this));
    }

    public void doDelete() {
        List selectedDisplays = this.getSelectedObjects();
        Iterator iter = selectedDisplays.iterator();
        while (iter.hasNext()) {
            GestureObjectDisplay display = (GestureObjectDisplay)iter.next();
            this.gestureContainer.remove(display.getDisplayedObject());
        }
    }

    public void doPaste() {
        Transferable transferable = GDTClipboard.getClipboard().getContents(this);
        if (transferable.isDataFlavorSupported(GestureFlavorFactory.GESTURE_OBJECT_FLAVOR)) {
            try {
                GestureObject obj = (GestureObject)transferable.getTransferData(GestureFlavorFactory.GESTURE_OBJECT_FLAVOR);
                this.gestureContainer.add(obj);
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("Transferable claimed it supported GESTURE_OBJECT_FLAVOR but it lied");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not paste due to I/O error.", "Paste failed", 0);
            }
        } else if (transferable.isDataFlavorSupported(GestureFlavorFactory.GESTURE_OBJECT_COLLECTION_FLAVOR)) {
            try {
                Collection collection = (Collection)transferable.getTransferData(GestureFlavorFactory.GESTURE_OBJECT_COLLECTION_FLAVOR);
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    GestureObject obj = (GestureObject)iter.next();
                    GestureObject newObj = (GestureObject)obj.clone();
                    this.gestureContainer.add(newObj);
                }
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("Transferable claimed it supported GESTURE_COLLECTION_OBJECT_FLAVOR but it lied");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not paste due to I/O error.", "Paste failed", 0);
            }
        } else {
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            System.err.println("ERROR: bad transferable: " + flavors[0].getHumanPresentableName());
        }
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public Dimension getPreferredSize() {
        Dimension result;
        Dimension ourDim = super.getPreferredSize();
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder) {
            Dimension borderDim = ((TitledBorder)border).getMinimumSize(this);
            int newWidth = (int)Math.max(borderDim.getWidth(), ourDim.getWidth());
            int newHeight = (int)Math.max(borderDim.getHeight(), ourDim.getHeight());
            result = new Dimension(newWidth, newHeight);
        } else {
            result = ourDim;
        }
        return result;
    }

    protected MouseListener getMouseListener() {
        return new GCMouseListener();
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform t = g2d.getTransform();
        g2d.scale(this.scale, this.scale);
        super.paint(g);
        g2d.setTransform(t);
    }

    public void setScale(double s) {
        this.scale = s;
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    protected class GCMouseListener
    extends SelectablePanel.SelectMouseListener {
        protected GCMouseListener() {
            super(GestureContainerPanel.this);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point location = e.getPoint();
                Component child = ((SelectablePanel.SingletonContainer)GestureContainerPanel.this.getComponentAt(location)).getContainee();
                if (child instanceof GestureObjectDisplay) {
                    GestureContainerPanel.this.fireActionEvent((GestureObjectDisplay)((Object)child), "OPEN", e.getModifiers());
                }
            } else {
                super.mouseClicked(e);
            }
        }
    }

    protected class MyCollectionListener
    extends CollectionAdapter {
        protected MyCollectionListener() {
        }

        public void elementAdded(CollectionEvent e) {
            GestureObject[] newObjs = (GestureObject[])e.getElements();
            GestureContainerPanel.this.insertGestureObjects(e.getStartIndex(), newObjs);
            GestureContainerPanel.this.revalidate();
            GestureContainerPanel.this.repaint();
        }

        public void elementRemoved(CollectionEvent e) {
            int i = 0;
            while (i < e.getElementCount()) {
                GestureContainerPanel.this.remove(e.getStartIndex() + i);
                ++i;
            }
            GestureContainerPanel.this.revalidate();
            GestureContainerPanel.this.repaint();
            CommandUtil.fireMenuValidChangeEvent(GestureContainerPanel.this.listenerList, new ChangeEvent(GestureContainerPanel.this));
        }
    }
}

