/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.EnableListener;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import edu.berkeley.guir.lib.gesture.apps.gdt.NoticeHandler;
import edu.berkeley.guir.lib.gesture.util.CollectionAdapter;
import edu.berkeley.guir.lib.gesture.util.CollectionEvent;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;

public class GestureCategoryThumbnailPanel
extends JPanel
implements GestureObjectDisplay,
GDTConstants {
    protected EventListenerList listenerList = new EventListenerList();
    protected CollectionListener listener = new MyCollectionListener();
    protected PropertyChangeListener propChangeListener = new MyPropChangeListener();
    protected GestureCategory category;
    protected JScrollPane scrollPane;
    protected double scale = 1.0;
    protected JComponent display;
    protected JLabel title;
    protected JPanel titlePanel;
    protected JButton noticeButton;
    protected boolean noticesVisible;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public GestureCategoryThumbnailPanel() {
        this((GestureCategory)null);
    }

    public GestureCategoryThumbnailPanel(GestureCategory category) {
        this(category, null);
    }

    public GestureCategoryThumbnailPanel(GestureCategory category, JScrollPane scrollPane) {
        super(new BorderLayout());
        this.scrollPane = scrollPane;
        this.buildUI();
        this.setCategory(category);
    }

    public void setCategory(GestureCategory cat) {
        if (cat != this.category) {
            if (this.category != null) {
                this.category.removeCollectionListener(this.listener);
                this.category.removePropertyChangeListener(this.propChangeListener);
            }
            this.category = cat;
            if (this.category != null) {
                this.category.addPropertyChangeListener(this.propChangeListener);
                this.category.addCollectionListener(this.listener);
            }
            this.updateThumbnail();
            this.updateTitle();
        }
    }

    public GestureObject getDisplayedObject() {
        return this.category;
    }

    protected void buildUI() {
        this.updateThumbnail();
        this.titlePanel = new JPanel(new BorderLayout());
        this.title = new JLabel();
        this.titlePanel.add((Component)this.title, "Center");
        this.add((Component)this.titlePanel, "South");
        this.noticeButton = new JButton(NoticeHandler.NOTICE_ICON);
        this.noticeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List notices = (List)GestureCategoryThumbnailPanel.this.category.getProperty("notice list");
                Notice firstNotice = (Notice)notices.get(0);
                int position = firstNotice.getPosition().getOffset();
                JTextPane textPane = GestureCategoryThumbnailPanel.this.getMainFrame().getSummaryLog().getTextPane();
                try {
                    Rectangle rect = textPane.modelToView(position);
                    textPane.scrollRectToVisible(rect);
                }
                catch (BadLocationException exception) {
                    System.err.println("WARNING: can't find the notice: " + firstNotice);
                }
            }
        });
        this.noticeButton.setMargin(new Insets(1, 1, 1, 1));
        this.addHierarchyListener(new HierarchyListener(){
            MainFrame mf;
            PropertyChangeListener listener;

            public void hierarchyChanged(HierarchyEvent e) {
                MainFrame newMf = GestureCategoryThumbnailPanel.this.getMainFrame();
                if (newMf != this.mf) {
                    if (this.mf != null) {
                        this.mf.removePropertyChangeListener("NOTICE_VISIBILITY_CHANGE_PROP", this.listener);
                    }
                    this.mf = newMf;
                    if (this.mf != null) {
                        this.listener = new PropertyChangeListener(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void propertyChange(PropertyChangeEvent pce) {
                                2.access$0(this.this$1).updateNoticeVisibility(this.this$1.mf);
                            }
                        };
                        this.mf.addPropertyChangeListener("NOTICE_VISIBILITY_CHANGE_PROP", this.listener);
                        GestureCategoryThumbnailPanel.this.updateNoticeVisibility(this.mf);
                    }
                }
            }

            static /* synthetic */ GestureCategoryThumbnailPanel access$0(2 var0) {
                return var0.GestureCategoryThumbnailPanel.this;
            }
        });
    }

    protected void updateThumbnail() {
        if (this.display != null) {
            this.remove(this.display);
        }
        if (this.category != null && this.category.size() > 0) {
            Gesture g = (Gesture)this.category.getChild(0);
            this.display = DisplayFactory.createThumbnail(g, this.scrollPane);
        } else {
            this.display = new JLabel("No examples");
        }
        this.add((Component)this.display, "Center");
        this.setPreferredSize(null);
        this.repaint();
        this.revalidate();
    }

    protected void updateNoticeVisibility(MainFrame mf) {
        this.noticesVisible = MainFrame.areWarningsEnabled();
        this.updateTitle();
    }

    protected void updateTitle() {
        this.title.setText(this.category == null ? "(null)" : this.category.getName());
        if (this.noticesVisible && this.category != null && NoticeHandler.hasNotices(this.category)) {
            this.titlePanel.add((Component)this.noticeButton, "West");
        } else {
            this.titlePanel.remove(this.noticeButton);
        }
        this.setPreferredSize(null);
        this.repaint();
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension result;
        Dimension ourDim = super.getPreferredSize();
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder) {
            Dimension borderDim = ((TitledBorder)border).getMinimumSize(this);
            int newWidth = (int)Math.max(borderDim.getWidth(), ourDim.getWidth());
            int newHeight = (int)Math.max(borderDim.getHeight(), ourDim.getHeight());
            result = new Dimension(newWidth, newHeight);
        } else {
            result = ourDim;
        }
        return result;
    }

    protected MainFrame getMainFrame() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MainFrame mf = (MainFrame)SwingUtilities.getAncestorOfClass(clazz, this);
        return mf;
    }

    public boolean isCommandValid(int id) {
        return false;
    }

    public void doCommand(int id) {
        System.err.println("GestureCategoryThumbnailPanel handles no commands (was given id " + id + ")");
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    public String getInputGestureTitle() {
        return null;
    }

    public boolean gestureDrawn(Gesture g) {
        System.err.println("GestureCategoryThumbnailPanel does not accept gestures");
        return false;
    }

    public boolean canAcceptGesture() {
        return false;
    }

    public void setScale(double s) {
        this.scale = s;
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform t = g2d.getTransform();
        g2d.scale(this.scale, this.scale);
        super.paint(g);
        g2d.setTransform(t);
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected class MyCollectionListener
    extends CollectionAdapter {
        protected MyCollectionListener() {
        }

        public void elementAdded(CollectionEvent e) {
            if (e.getStartIndex() == 0 || e.getElementCount() == GestureCategoryThumbnailPanel.this.category.size()) {
                GestureCategoryThumbnailPanel.this.updateThumbnail();
            }
        }

        public void elementRemoved(CollectionEvent e) {
            if (e.getStartIndex() == 0) {
                GestureCategoryThumbnailPanel.this.updateThumbnail();
            }
        }
    }

    protected class MyPropChangeListener
    extends EnableListener {
        final Border BASIC_BORDER;
        private Color oldBG;

        public MyPropChangeListener() {
            super(GestureCategoryThumbnailPanel.this);
            this.BASIC_BORDER = BorderFactory.createLineBorder(Color.green, 3);
            this.oldBG = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "name" || e.getPropertyName() == "notice list") {
                GestureCategoryThumbnailPanel.this.updateTitle();
            } else if ("correctly recognized" == e.getPropertyName()) {
                Color newBG;
                if (e.getNewValue() == null) {
                    newBG = this.oldBG;
                } else {
                    this.oldBG = GestureCategoryThumbnailPanel.this.getBackground();
                    newBG = Color.white;
                }
                GestureCategoryThumbnailPanel.this.setBackground(newBG);
                GestureCategoryThumbnailPanel.this.getComponent(0).setBackground(newBG);
            } else {
                super.propertyChange(e);
            }
        }
    }
}

