/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureGroup;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureContainerPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureFlavorFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import edu.berkeley.guir.lib.gesture.util.Gensym;
import edu.berkeley.guir.lib.gesture.util.SelectablePanel;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class GestureCategoryPanel
extends GestureContainerPanel
implements GestureObjectDisplay {
    static /* synthetic */ Class class$0;

    public GestureCategoryPanel() {
        this((GestureCategory)null);
    }

    public GestureCategoryPanel(GestureCategory gc) {
        this(gc, null);
    }

    public GestureCategoryPanel(GestureCategory gc, JScrollPane scrollPane) {
        super(gc, scrollPane);
    }

    protected void addGestureObject(GestureObject gestureObj, JScrollPane scrollPane, int index) {
        JComponent widget = DisplayFactory.create(gestureObj, scrollPane);
        widget.setBorder(BorderFactory.createEtchedBorder());
        if (widget instanceof SelectablePanel) {
            ((SelectablePanel)widget).setSelectable(false);
        }
        this.add((Component)widget, index);
    }

    public void setGestureContainer(GestureContainer container) {
        if (container != null && !(container instanceof GestureCategory)) {
            throw new IllegalArgumentException("Only GestureCategory is allowed, not " + container.getClass().getName() + " (" + container + ")");
        }
        super.setGestureContainer(container);
    }

    public boolean canAcceptGesture() {
        return true;
    }

    public boolean gestureDrawn(Gesture gesture) {
        GestureCategory gestureCategory = (GestureCategory)this.getGestureContainer();
        gesture.normalize();
        gestureCategory.addGesture(gesture);
        return true;
    }

    public String getInputGestureTitle() {
        return "Draw a new example gesture";
    }

    public boolean canPaste(Transferable t) {
        return t.isDataFlavorSupported(GestureFlavorFactory.GESTURE_EXAMPLE_COLLECTION_FLAVOR) || t.isDataFlavorSupported(GestureFlavorFactory.GESTURE_EXAMPLE_FLAVOR);
    }

    public boolean isCommandValid(int id) {
        boolean valid;
        switch (id) {
            case 401: 
            case 402: {
                valid = true;
                break;
            }
            default: {
                valid = super.isCommandValid(id);
            }
        }
        return valid;
    }

    public GestureSet getContainingSet() {
        GestureObject gestureObject = this.getDisplayedObject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GestureSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (GestureSet)AbstractGestureContainer.findAncestorOfClass(gestureObject, clazz);
    }

    public void doCommand(int id) {
        switch (id) {
            case 401: {
                this.getContainingSet().add(new GestureCategory(Gensym.next("gesture")));
                break;
            }
            case 402: {
                this.getContainingSet().add(new GestureGroup(Gensym.next("group")));
                break;
            }
            default: {
                super.doCommand(id);
            }
        }
    }
}

