/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.CommandUtil;
import edu.berkeley.guir.lib.gesture.apps.gdt.Commander;
import edu.berkeley.guir.lib.gesture.apps.gdt.DisplayFactory;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GInternalFrame
extends JInternalFrame
implements Commander {
    private GestureObjectDisplay gestureObjectDisplay;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    protected GInternalFrame() {
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
    }

    public static GInternalFrame makeInternalFrame(GestureObject data) {
        return GInternalFrame.makeInternalFrame(data, data.getParent().getName());
    }

    public static GInternalFrame makeInternalFrame(GestureObject data, String parentName) {
        JScrollPane scroller = new JScrollPane();
        JComponent display = DisplayFactory.create(data, scroller);
        return GInternalFrame.makeInternalFrame(data, display, scroller);
    }

    public static GInternalFrame makeInternalFrame(final GestureObject data, JComponent display, JScrollPane scroller) {
        GInternalFrame frame = new GInternalFrame();
        frame.gestureObjectDisplay = (GestureObjectDisplay)((Object)display);
        scroller.setViewportView(display);
        display.setBorder(null);
        frame.gestureObjectDisplay.addMenuValidChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CommandUtil.fireMenuValidChangeEvent(GInternalFrame.this.listenerList, e);
            }
        });
        data.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propName = e.getPropertyName();
                if (propName == "name") {
                    GInternalFrame.this.updateTitle();
                } else if (propName == "parent" && e.getNewValue() == null) {
                    try {
                        GInternalFrame.this.setClosed(true);
                    }
                    catch (PropertyVetoException exception) {
                        System.err.println("WARNING: could not close display for " + data);
                    }
                }
            }
        });
        frame.updateTitle();
        Container contents = frame.getContentPane();
        contents.setLayout(new BorderLayout());
        contents.add((Component)scroller, "Center");
        if (data instanceof GestureContainer) {
            GInternalFrame gInternalFrame = frame;
            gInternalFrame.getClass();
            contents.add((Component)gInternalFrame.new SizeLabel((GestureContainer)data), "South");
        }
        return frame;
    }

    public void updateTitle() {
        StringBuffer title = new StringBuffer();
        GestureObject data = this.gestureObjectDisplay.getDisplayedObject();
        if (data instanceof GestureContainer) {
            String name = ((GestureContainer)data).getName();
            title.append(name == null ? "(unnamed)" : name);
        } else {
            title.append("example");
        }
        this.setTitle(title.toString());
        this.repaint();
    }

    public GestureObjectDisplay getGestureObjectDisplay() {
        return this.gestureObjectDisplay;
    }

    public boolean isCommandValid(int id) {
        return this.gestureObjectDisplay.isCommandValid(id);
    }

    public void doCommand(int id) {
        this.gestureObjectDisplay.doCommand(id);
    }

    public void addMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuValidChangeListener(ChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    protected class SizeLabel
    extends JLabel
    implements PropertyChangeListener {
        protected GestureContainer gestureContainer;

        public SizeLabel(GestureContainer gc) {
            this.setGestureContainer(gc);
        }

        public void setGestureContainer(GestureContainer gc) {
            if (this.gestureContainer != gc) {
                if (this.gestureContainer != null) {
                    this.gestureContainer.removePropertyChangeListener(this);
                }
                this.gestureContainer = gc;
                if (this.gestureContainer != null) {
                    this.gestureContainer.addPropertyChangeListener(this);
                }
                this.updateTitle();
            }
        }

        protected void updateTitle() {
            this.setText(String.valueOf(this.gestureContainer.size()) + " elements");
            this.repaint();
            this.revalidate();
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("children" == e.getPropertyName()) {
                this.updateTitle();
            }
        }
    }
}

