/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.GDTConstants;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class GDTUtil
implements GDTConstants {
    protected static final String DELETE_LISTENER_PROP = "DELETE_LISTENER_PROP";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void setProperty(Collection gestureObjs, String name, Object value) {
        GDTUtil.setProperty(gestureObjs, name, value, false);
    }

    public static void setProperty(Collection gestureObjs, String name, Object value, boolean recursive) {
        GDTUtil.setProperty(gestureObjs.iterator(), name, value, recursive);
    }

    public static void setProperty(Iterator iter, String name, Object value, boolean recursive) {
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof GestureObject)) continue;
            GestureObject gestureObj = (GestureObject)obj;
            gestureObj.setProperty(name, value);
            if (!recursive || !(gestureObj instanceof GestureContainer)) continue;
            GDTUtil.setProperty(((GestureContainer)gestureObj).iterator(), name, value, true);
        }
    }

    public static void unsetProperty(Iterator iter, String name, boolean recursive) {
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof GestureObject)) continue;
            GestureObject gestureObj = (GestureObject)obj;
            gestureObj.unsetProperty(name);
            if (!recursive || !(gestureObj instanceof GestureContainer)) continue;
            GDTUtil.unsetProperty(((GestureContainer)gestureObj).iterator(), name, true);
        }
    }

    public static void setEnabledRecursively(GestureContainer container, boolean value) {
        container.setEnabled(value);
        GDTUtil.setEnabledOnForest(container.iterator(), value);
    }

    public static void setEnabledOnForest(Collection forest, boolean value) {
        GDTUtil.setEnabledOnForest(forest.iterator(), value);
    }

    public static void setEnabledOnForest(Iterator iter, boolean value) {
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof GestureObject)) continue;
            GestureObject gestureObj = (GestureObject)obj;
            gestureObj.setEnabled(value);
            if (!(gestureObj instanceof GestureContainer)) continue;
            GDTUtil.setEnabledOnForest(((GestureContainer)gestureObj).iterator(), value);
        }
    }

    public static boolean contains(int[] array, int n) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static SummaryLog getSummaryLog(Component component) {
        MainFrame mf;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (mf = (MainFrame)SwingUtilities.getAncestorOfClass(clazz, component)) == null ? null : mf.getSummaryLog();
    }

    public static void addDeleteListener(final GestureObjectDisplay display) {
        final JComponent jDisplay = (JComponent)((Object)display);
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName() == "parent" && e.getNewValue() == null) {
                    JInternalFrame iFrame;
                    System.out.println("parent change for " + e.getSource() + ": " + e.getOldValue() + e.getNewValue());
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("javax.swing.JInternalFrame");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(clazz, jDisplay)) != null) {
                        try {
                            iFrame.setClosed(true);
                        }
                        catch (PropertyVetoException exception) {
                            System.err.println("WARNING: could not close display for " + display.getDisplayedObject());
                        }
                    }
                }
            }
        };
        display.getDisplayedObject().addPropertyChangeListener("parent", listener);
        jDisplay.putClientProperty(DELETE_LISTENER_PROP, listener);
    }

    public static void removeDeleteListener(GestureObjectDisplay display) {
        JComponent jDisplay = (JComponent)((Object)display);
        PropertyChangeListener listener = (PropertyChangeListener)jDisplay.getClientProperty(DELETE_LISTENER_PROP);
        if (listener != null) {
            display.getDisplayedObject().removePropertyChangeListener("parent", listener);
        }
    }
}

