/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import java.util.Collections;
import java.util.List;

public class FeatureNotice
extends DefaultNotice {
    protected Feature feature;
    protected int direction;
    protected GestureObject relatedGObject;

    public FeatureNotice(Feature f, GestureObject relatedObj, int direction) {
        this.feature = f;
        this.direction = direction;
        this.relatedGObject = relatedObj;
    }

    protected void displayImpl(SummaryLog log) {
        log.append("This gesture is different from its gesture category mostly because its ");
        log.appendLink(this.feature.getName(), this.referenceListener, "Get an explanation for this feature");
        String directionString = this.direction < 0 ? "low" : "high";
        log.append(" is too " + directionString + ".");
    }

    protected void displaySummaryImpl(SummaryLog log) {
        log.appendLink(this.feature.getName(), this.referenceListener, "Get an explanation for this feature");
        String directionString = this.direction < 0 ? "low" : "high";
        log.append(": too " + directionString);
    }

    public String getName() {
        return "Feature";
    }

    public String getReferenceTag() {
        String fullClassName = this.feature.getClass().getName();
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public List getObjectList() {
        return Collections.singletonList(this.relatedGObject);
    }
}

