/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.apps.gdt.DefaultNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.HowToPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextArea;

public class DuplicateNameNotice
extends DefaultNotice {
    private GestureContainer[] containers;
    private String name;
    private boolean displayMe = true;

    public DuplicateNameNotice(GestureContainer gc1, GestureContainer gc2) {
        GestureContainer[] dummy = new GestureContainer[]{gc1, gc2};
        this.containers = dummy;
        this.name = gc1.getName();
    }

    public boolean hasExpired() {
        return this.containers[0].getName() != this.name || this.containers[1].getName() != this.name;
    }

    protected void displayImpl(SummaryLog log) {
        if (this.displayMe) {
            log.append("Warning: two gestures share the name '" + this.name + "'. You should rename one.");
            this.displayMe = false;
        }
    }

    protected void displaySummaryImpl(SummaryLog log) {
    }

    public String getName() {
        return "Duplicate name: '" + this.name + "'";
    }

    public List getObjectList() {
        return Arrays.asList(this.containers);
    }

    public HowToPanel getHowToPanel() {
        HowToPanel htPanel = new HowToPanel();
        htPanel.add((Component)new JTextArea("To rename an object, select it in the tree and execute the 'Gesture/Rename' menu item."), "Center");
        return htPanel;
    }

    public String getReferenceTag() {
        return "Duplicate Names";
    }
}

